function [] = show_PlygnMesh_labels(PlygnMesh,fwn,ch0,ch1,ch2)
%% Show a small-size polygonal mesh with labels for visual verification 
% fwn: figure window number 
% James Liu, ColoState; 2012/07--2019/09 

%% Mesh info 
NumNds = PlygnMesh.NumNds;
NumEms = PlygnMesh.NumEms;
NumEgs = PlygnMesh.NumEgs;
ElemType = PlygnMesh.ElemType;
node = PlygnMesh.node;
elem = PlygnMesh.elem;
edge = PlygnMesh.edge;
EmCntr = PlygnMesh.EmCntr;

%% Preparation for plotting 
% Element centers 
% EmCntr = zeros(NumEms,2);
% for ie=1:NumEms
%   EmCntr(ie,:) = sum(node(elem{ie}(:),:),1)/ElemType(ie);
% end
xec = EmCntr(:,1);
yec = EmCntr(:,2);
% Edge centers 
xgc = 0.5*(node(edge(:,1),1)+node(edge(:,2),1));
ygc = 0.5*(node(edge(:,1),2)+node(edge(:,2),2));

%% Plotting 
figure(fwn);
set(gca,'fontsize',18);
%
% Filling polygons 
for ie=1:NumEms
  xx = zeros(ElemType(ie),1);
  yy = zeros(ElemType(ie),1);
  for j=1:ElemType(ie)
    xx(j) = node(elem{ie}(j),1);
    yy(j) = node(elem{ie}(j),2);
  end
  fill(xx,yy,'w','LineWidth',1.5);
  hold on;
end
%
% Show nodal labels 
if ch0==1 
  for id=1:NumNds
    text(node(id,1),node(id,2),['\bf',num2str(id)],'fontsize',18);
  end
end
%
% Show edge labels 
if ch1==1 
  for ig=1:NumEgs
    text(xgc(ig),ygc(ig),['\color{red}',num2str(ig)], 'fontsize',18);
  end
end
%
% Show element labels 
if ch2==1 
  for ie=1:NumEms
    text(xec(ie),yec(ie),num2str(ie),'EdgeColor','blue','fontsize',18);
  end
end
% 
% title('A small polygonal mesh');
% title(['\bf', 'Nodes: bold black;  Elements: blue box;  Edges: red']);
axis equal;  axis tight;
axis off;

return;