function [] = show_PlygnMesh_Streamlines(... 
  PlygnMesh, NumerVelEm, startx, starty, nx, ny, fwn)
%% Plotting streamlines for a polygonal mesh  
% xstart, ystart are vectors of the same length
% nx, ny are the dimensions of the meshgrid placed over the PlygnMesh
% Graham Harper, James Liu, ColoState; 2017/08--2019/09

%% Mesh info 
nodes = PlygnMesh.node;
xmin = min(nodes(:,1));
xmax = max(nodes(:,1));
ymin = min(nodes(:,2));
ymax = max(nodes(:,2));

%% meshgrid 
[X,Y] = meshgrid(linspace(xmin,xmax,nx), linspace(ymin,ymax,ny));
U = zeros(ny,nx);
V = zeros(ny,nx);

%% Preparing 
for ix=1:ny
  for iy=1:nx
    for ic=1:PlygnMesh.NumEms
      % if(inpolygon(X(ix,iy),Y(ix,iy),PlygnMesh.node(PlygnMesh.elem{ic},1),PlygnMesh.node(PlygnMesh.elem{ic},2)))
      elem_xy = PlygnMesh.node(PlygnMesh.elem{ic},:);
      if(X(ix,iy)>=min(elem_xy(:,1)) && X(ix,iy)<=max(elem_xy(:,1)) && Y(ix,iy)>=min(elem_xy(:,2)) && Y(ix,iy)<=max(elem_xy(:,2)))
        U(ix,iy) = NumerVelEm(ic,1);
        V(ix,iy) = NumerVelEm(ic,2);
        break;
      end
    end
  end
end

%% Showing 
figure(fwn)
hlines = streamline(X,Y,U,V,startx,starty);
set(hlines,'Color','k','LineWidth',1);

return;