function [] = show_PlygnMesh_ScaVecEm_mix(PlygnMesh,ScaEm,VecEm,fwn,ts,mf)
%% PlygnMesh: Show scalar+vector (emws.const.) as a mix of color image and quiver
% fwn: figure window number 
%  ts: title string for the figure window
%  mf: magnifying factor for vectors (length magnified mf times)  
% James Liu, ColoState; 2012/07--2017/08 

%% Mesh info 
node = PlygnMesh.node;
elem = PlygnMesh.elem;
% Assuming PlygnMesh.flag=3 

%% Mesh info 
NumNds = PlygnMesh.NumNds;
NumEms = PlygnMesh.NumEms;
NumEgs = PlygnMesh.NumEgs;
ElemType = PlygnMesh.ElemType;
node = PlygnMesh.node;
elem = PlygnMesh.elem;
edge = PlygnMesh.edge;

%% Plotting 
figure(fwn);
set(gca,'fontsize',24);
%
% For the scalar: Filling polygons 
for ie=1:NumEms
  xx = zeros(ElemType(ie),1);
  yy = zeros(ElemType(ie),1);
  for j=1:ElemType(ie)
    xx(j) = node(elem{ie}(j),1);
    yy(j) = node(elem{ie}(j),2);
  end
  % fill(xx,yy,'w');
  fill(xx,yy,ScaEm(ie),'LineStyle','none'); %arguments 'LineStyle' 'none' to remove mesh
  hold on;
end
%
% For the vector
hold on;
quiver(PlygnMesh.EmCntr(:,1), PlygnMesh.EmCntr(:,2), ...
  VecEm(:,1),VecEm(:,2),mf,'k');%,'linewidth',1.5);  % vectors magnified mf times
%
% For the figure
colorbar('location','eastoutside','fontsize',18);
colormap jet;
title(ts,'fontsize',18);
axis equal;  axis tight;
% axis square;

return;