%% run_Stokes_WG_PlygnP02P02CW02P0_LidDrivenCavity.m 
% Solving Stokes eqn. by WG(P0^2,P0^2;CW0^2,P0) on a polygonal mesh
% Graham Harper, James Liu, ColoState; 2017/08--2019/09 

% clc;  
clear all;  close all;
format compact;  format short e;

%% Setting up the problem: Domain; Boundary condition type 
% Boundary condition types: 1 Dirichlet, 2 Neumann, 0 convenience 
% For lid-driven cavity 
xa = 0;  xb = 1;  yc = 0;  yd = 1;
BndryDescMat = [xa,yc,xb,yc, 0,-1; ...
                xb,yc,xb,yd, 1, 0; ... 
                xb,yd,xa,yd, 0, 1; ...
                xa,yd,xa,yc,-1, 0];
EqnBC = EqnBC_Stokes_LidDrivenCavity;
BndryCondType = [0;1;1;1;1];
mu = EqnBC.mu;

%% Discretization: Mesh generation and preparation 
% For lid-driven cavity with a rectangular mesh 
n = 2^5;  nx = n;  ny = n;  delta = 0;  status = 2;
QuadriMesh = RectDom_QuadriMesh_GenLogiRectPtbSmth( ...
  xa,xb,nx, yc,yd,ny, delta,status);
PlygnMesh = PlygnMesh_ConvFrom_QuadriMesh(QuadriMesh);
PlygnMesh = PlygnMesh_Enrich1(PlygnMesh);
PlygnMesh = PlygnMesh_Enrich2(PlygnMesh,BndryDescMat);
PlygnMesh = PlygnMesh_Enrich6(PlygnMesh,BndryDescMat);
diam = max(PlygnMesh.radius) + min(PlygnMesh.radius);
[PlygnMesh.NumNds, PlygnMesh.NumEms, PlygnMesh.NumEgs]
% [PlygnMesh.NumEms, diam] 
% PlygnMesh.maxn 
if PlygnMesh.NumEms<=2^6
  show_PlygnMesh_labels(PlygnMesh,11,1,0,0);
end

%% Setting up Gaussian quadratures 
GAUSSQUAD = SetGaussQuad(5,25,9);

%% WG(P0^2,P0^2;CW0^2,P0)Plygn for Stokes: Assembling & Solving
% tic;
[sln] = Stokes_WG_PlygnP02P02CW02P0_AsmSlv( ...
  EqnBC,BndryCondType,PlygnMesh,GAUSSQUAD);
% toc

%% Comput. numer. velocity, pressure, div.residual: Coeffs. in resp.bases 
[NumerVelCofP02,NumerPresCofP0,NumerDivCofP0] = ...
  Stokes_WG_PlygnP02P02CW02P0_VelPresDiv(mu,PlygnMesh,sln,GAUSSQUAD);
NumerVelEm = NumerVelCofP02;
NumerPresEm = NumerPresCofP0;
NumerDivEm = NumerDivCofP0;

%% Checking properties 
NumerPresEm = NumerPresEm - 0.5*(min(NumerPresEm)+max(NumerPresEm));

%% Presenting numerical and graphical results
  show_PlygnMesh_ScaVecEm_mix(PlygnMesh, NumerPresEm, NumerVelEm, ...
    22, 'WG0 numerical velocity & pressure', 1);
% end

return;