%% run_Stokes_WG_PlygnP02P02CW02P0_FOBS.m (Flow Over a Back Step) 
% Solving Stokes eqn. by WG(P0^2,P0^2;CW0^2,P0) on a polygonal mesh 
% Graham Harper, James Liu, ColoState; 2017/08--2019/09

% clc;  
clear all;  close all;
format compact;  format short e;

%% Setting up the problem: Domain; Boundary condition type 
% Boundary condition types: 1 Dirichlet, 2 Neumann, 0 convenience 
% For Flow Over a Back Step (FOBS) (a special domain) 
BndryDescMat = [-1, 0,-1, 1,-1, 0;   % Left 
                -1, 1, 5, 1, 0, 1;   % Top 
                 5, 1, 5,-1, 1, 0;   % Right 
                 5,-1, 0,-1, 0,-1;   % Bottom 
                 0,-1, 0, 0,-1, 0;   % Step side 
                 0, 0,-1, 0, 0,-1];  % Step top 
EqnBC = EqnBC_Stokes_FlowOverBackStep;
BndryCondType = [0;1;1;1;1;1;1];
mu = EqnBC.mu;

%% Discretization: Mesh generation and preparation 
% For FOBS: Using quadrilateral (rectangular) meshes 
QuadriMesh = DomFOBS_QuadriMesh_GenInit();
for k=1:4
  QuadriMesh = QuadriMesh_RefineReg(QuadriMesh);
end
PlygnMesh = PlygnMesh_ConvFrom_QuadriMesh(QuadriMesh);
PlygnMesh = PlygnMesh_Enrich1(PlygnMesh);
PlygnMesh = PlygnMesh_Enrich2(PlygnMesh,BndryDescMat);
PlygnMesh = PlygnMesh_Enrich6(PlygnMesh,BndryDescMat);
diam = max(PlygnMesh.radius) + min(PlygnMesh.radius);
[PlygnMesh.NumNds, PlygnMesh.NumEms, PlygnMesh.NumEgs]
% [PlygnMesh.NumEms, diam] 
% PlygnMesh.maxn 
if PlygnMesh.NumEms<=2^6
  show_PlygnMesh_labels(PlygnMesh,11,1,0,0);
end

%% Setting up Gaussian quadratures 
GAUSSQUAD = SetGaussQuad(5,25,9);

%% WG(P0^2,P0^2;CW0^2,P0)Plygn for Stokes: Assembling & Solving
% tic;
[sln] = Stokes_WG_PlygnP02P02CW02P0_AsmSlv( ...
  EqnBC,BndryCondType,PlygnMesh,GAUSSQUAD);
% toc

%% Comput. numer. velocity, pressure, div.residual: Coeffs. in resp.bases 
[NumerVelCofP02,NumerPresCofP0,NumerDivCofP0] = ...
  Stokes_WG_PlygnP02P02CW02P0_VelPresDiv(mu,PlygnMesh,sln,GAUSSQUAD);
NumerVelEm = NumerVelCofP02;
NumerPresEm = NumerPresCofP0;
NumerDivEm = NumerDivCofP0;

%% Checking properties 
NumerPresEm = NumerPresEm - 0.5*(min(NumerPresEm)+max(NumerPresEm));

%% Presenting numerical and graphical results
% if PlygnMesh.NumEms<=2^14
  show_PlygnMesh_ScaVecEm_mix(PlygnMesh, NumerPresEm, NumerVelEm, ...
    22, 'WG0 numerical velocity & pressure', 1);
  show_PlygnMesh_ScaEm_ClrImg(PlygnMesh, NumerPresEm, ... 
    23, 'WG0 streamlines');
%  print -f23 -dpng Stokes_Ex_WG0Plygn_NumerVelPres_n.png 
% end

%% Plooting streamlines for FOBS 
startx = [-0.99,-0.99,-0.99,-0.99,-0.99,0.05,0.05,0.05,0.05,0.05];
starty = [0.1,0.3,0.5,0.7,0.9,-0.1,-0.3,-0.5,-0.7,-0.9];
nx_streams = 6*(2^4);
ny_streams = 2*(2^4);
show_PlygnMesh_Streamlines(PlygnMesh, NumerVelEm, ...
  startx, starty, nx_streams, ny_streams, 23);

return;