function CDWDB = WG_PlygnP02P02P0_CofNmlzBas_DiscWkDivBasFxn(PlygnMesh)
%% Cofs. in P0 nmlz.bas. for disc.wk.div. of 2+2n WG(P0^2,P0^2) bas.fxns. 
% on a convex polygonal mesh 
% James Liu, Graham Harper, ColoState; 2017/07--2017/08 

%% Mesh info 
NumEms = PlygnMesh.NumEms;

%% 
CDWDB = cell(NumEms,1);
for ie=1:NumEms
  n = PlygnMesh.ElemType(ie);
  CDWDB{ie} = zeros(1,2+2*n);
  NmlEg = zeros(n,2);  % Edge "normal" vector carrying edge length info 
  for j=1:n
    j1 = mod(j,n) + 1;
    x1 = PlygnMesh.node(PlygnMesh.elem{ie}(j),1);
    y1 = PlygnMesh.node(PlygnMesh.elem{ie}(j),2);
    x2 = PlygnMesh.node(PlygnMesh.elem{ie}(j1),1);
    y2 = PlygnMesh.node(PlygnMesh.elem{ie}(j1),2);    
    NmlEg(j,1) = y2 - y1;
    NmlEg(j,2) = x1 - x2;
    CDWDB{ie}(2+2*j-1) = NmlEg(j,1)/PlygnMesh.area(ie);
    CDWDB{ie}(2+2*j  ) = NmlEg(j,2)/PlygnMesh.area(ie);
  end
end

return;