%% TO BE FINISHED BY Graham 
function CDWGB = WG_PlygnP02P02CW02_Wachspress_DiscWkGradBasFxn( ...
  PlygnMesh,GAUSSQUAD)
%% Cofs. in CW0^2 bas. for disc.wk.grad. of 2+2*n WG(P0^2,P0^2) bas.fxns. 
% on a convex polygonal mesh 
% James Liu, Graham Harper, ColoState; 2017/07--2017/08 

%% Mesh info 
NumEms = PlygnMesh.NumEms; 
% Length of edges 
LenEg = cell(NumEms,1);
for ie=1:NumEms
  n = PlygnMesh.ElemType(ie);
  LenEg{ie} = zeros(1,n);
  for j=1:n
    j1 = mod(j,n) + 1;
    x1 = PlygnMesh.node(PlygnMesh.elem{ie}(j),1);
    y1 = PlygnMesh.node(PlygnMesh.elem{ie}(j),2);
    x2 = PlygnMesh.node(PlygnMesh.elem{ie}(j1),1);
    y2 = PlygnMesh.node(PlygnMesh.elem{ie}(j1),2);
    LenEg{ie}(j) = sqrt((x2-x1)^2+(y2-y1)^2);
  end
end

%% 
GM = Hdiv_PlygnCW02_Wachspress_GramMat(PlygnMesh,GAUSSQUAD);

%% 
RHS = cell(NumEms,1);
for ie=1:NumEms
  n = PlygnMesh.ElemType(ie);
  RHS{ie} = zeros(2*n, 2+2*n);
  for j=1:n  %  The j-th edge 
    RHS{ie}(2*j-1,1) = -LenEg{ie}(j);
    RHS{ie}(2*j,  2) = -LenEg{ie}(j);
    RHS{ie}(2*j-1, 2*j+1) = LenEg{ie}(j);
    RHS{ie}(2*j,   2*j+2) = LenEg{ie}(j);
  end
end

%%
CDWGB = cell(NumEms,1);
for ie=1:NumEms
  n = PlygnMesh.ElemType(ie);
  EltGM = GM{ie};
  for j=1:(2+2*n)
    EltRHS = RHS{ie}(:,j);
    CDWGB{ie}(j,:) = EltGM\EltRHS;
  end
end

return;