function [NumerVelCofP02,NumerPresCofP0,NumerDivCofP0] = ...
  Stokes_WG_PlygnP02P02CW02P0_VelPresDiv(mu,PlygnMesh,sln,GAUSSQUAD)
%% Computing numerical velocity, pressure, divergence (residual?) 
% Elementwise coefficients in respective bases 
% James Liu, ColoState; 2017/07--2018/12 

%% Mesh info 
NumEms = PlygnMesh.NumEms;
NumEgs = PlygnMesh.NumEgs;

%% Elementwise coeffs. in 2+2n+1 WG basis functions from numer.sln. 
cof = cell(NumEms,1);
for ie=1:NumEms
  n = PlygnMesh.ElemType(ie);
  cof{ie} = zeros(1,2+2*n+1);
  cof{ie}(1) = sln(2*ie-1);
  cof{ie}(2) = sln(2*ie);
  for j=1:n
    k = PlygnMesh.elem2edge{ie}(j);
    cof{ie}(2*j+1) = sln(2*NumEms+2*k-1);
    cof{ie}(2*j+2) = sln(2*NumEms+2*k  );
  end
  cof{ie}(2+2*n+1) = sln(2*NumEms+2*NumEgs+ie);
end

%% Elementwise coefficients in P0^2 for numerical velocity 
NumerVelCofP02 = zeros(NumEms,2);
for ie=1:NumEms
  NumerVelCofP02(ie,1) = cof{ie}(1);
  NumerVelCofP02(ie,2) = cof{ie}(2);
end

%% Elementwise coefficients in P0 for numerical pressure 
NumerPresCofP0 = zeros(NumEms,1);
for ie=1:NumEms
  n = PlygnMesh.ElemType(ie);
  NumerPresCofP0(ie) = cof{ie}(2+2*n+1);
end

% %% Elementwise coefficients for disc.wk.grad. of (2+2n) WG basis functions 
% CDWGB = WG_PlygnP02P02CW02_Wachspress_DiscWkGradBasFxn(PlygnMesh,GAUSSQUAD);

%% Elementwise coefficients for disc.wk.div. of (2+2n) WG basis functions 
CDWDB = WG_PlygnP02P02P0_CofNmlzBas_DiscWkDivBasFxn(PlygnMesh);

%% Elementwise coefficients in P0 for numerical divergence 
NumerDivCofP0 = zeros(NumEms,1);
for ie=1:NumEms
  n = PlygnMesh.ElemType(ie);
  size(cof{ie}(1:2+2*n)); 
  size(CDWDB{ie}(:));
  NumerDivCofP0(ie) = sum(cof{ie}(1:2+2*n)*CDWDB{ie}(:));
end

%% JL20181208: How to understand the above divergence (residual)? 

return;