function [L2ErrVel,L2ErrPres] = ...
  Stokes_WG_PlygnP02P02CW02P0_Err( ...
  EqnBC,PlygnMesh,NumerVelCofP02,NumerPresCofP0,GAUSSQUAD)
%% Stokes: WG(P0^2,P0^2;CW0^2,P0)Plygn: Computing errors 
% James Liu, ColoState; 2017/08--2019/02 

%% Mesh info 
NumEms = PlygnMesh.NumEms;

%% Errors:  
%  L2ErrVel:  L^2-norm of error in velocity (for element interior) 
%  L2ErrPres: L^2-norm of error in pressure 

%% Computing L2-norm of error in velocity (element interior) 
EmErrVel = zeros(NumEms,1);
NumerVel = zeros(NumEms,2);
NumerVel(:,1) = NumerVelCofP02(:,1);
NumerVel(:,2) = NumerVelCofP02(:,2);
NumQuadPts = size(GAUSSQUAD.TRIG,1);
for ie=1:NumEms
  EmErrVel(ie) = 0;
  n = PlygnMesh.ElemType(ie);
  for m=1:(n-2)
    x1 = PlygnMesh.node(PlygnMesh.elem{ie}(1),1);
    y1 = PlygnMesh.node(PlygnMesh.elem{ie}(1),2);
    x2 = PlygnMesh.node(PlygnMesh.elem{ie}(m+1),1);
    y2 = PlygnMesh.node(PlygnMesh.elem{ie}(m+1),2);
    x3 = PlygnMesh.node(PlygnMesh.elem{ie}(m+2),1);
    y3 = PlygnMesh.node(PlygnMesh.elem{ie}(m+2),2);
    ar = abs(0.5*((x2-x1).*(y3-y1)-(x3-x1).*(y2-y1)));
    for k=1:NumQuadPts
      qp = GAUSSQUAD.TRIG(k,1) * [x1,y1] ...
         + GAUSSQUAD.TRIG(k,2) * [x2,y2] ...
         + GAUSSQUAD.TRIG(k,3) * [x3,y3] ;
      uval = EqnBC.fxnu(qp);
      uerr = uval - NumerVel(ie,:);
      EmErrVel(ie) = EmErrVel(ie) ... 
        + GAUSSQUAD.TRIG(k,4) * (uerr(1)^2+uerr(2)^2) * ar;
    end
  end
end
L2ErrVel = sqrt(sum(EmErrVel));

%% Computing the projected pressure (or average) only for the 1st element 
ProjPresEm1 = 0;
NumQuadPts = size(GAUSSQUAD.TRIG,1);
for ie = 1:1
  n = PlygnMesh.ElemType(ie);
  for m=1:(n-2)
    x1 = PlygnMesh.node(PlygnMesh.elem{ie}(1),1);
    y1 = PlygnMesh.node(PlygnMesh.elem{ie}(1),2);
    x2 = PlygnMesh.node(PlygnMesh.elem{ie}(m+1),1);
    y2 = PlygnMesh.node(PlygnMesh.elem{ie}(m+1),2);
    x3 = PlygnMesh.node(PlygnMesh.elem{ie}(m+2),1);
    y3 = PlygnMesh.node(PlygnMesh.elem{ie}(m+2),2);
    for k=1:NumQuadPts
      qp = GAUSSQUAD.TRIG(k,1) * [x1,y1] ...
         + GAUSSQUAD.TRIG(k,2) * [x2,y2] ...
         + GAUSSQUAD.TRIG(k,3) * [x3,y3] ;
      ExactPres = EqnBC.fxnp(qp);
      ProjPresEm1 = ProjPresEm1 + GAUSSQUAD.TRIG(k,4) * ExactPres;
    end
  end
end

%% Shifting the numerical pressure 
NumerPres = NumerPresCofP0 - NumerPresCofP0(1) + ProjPresEm1;

%% Computing L2-norm of error in pressure 
EmErrPres = zeros(NumEms,1);
NumQuadPts = size(GAUSSQUAD.TRIG,1);
for ie=1:NumEms
  n = PlygnMesh.ElemType(ie);
  for m=1:(n-2)
    x1 = PlygnMesh.node(PlygnMesh.elem{ie}(1),1);
    y1 = PlygnMesh.node(PlygnMesh.elem{ie}(1),2);
    x2 = PlygnMesh.node(PlygnMesh.elem{ie}(m+1),1);
    y2 = PlygnMesh.node(PlygnMesh.elem{ie}(m+1),2);
    x3 = PlygnMesh.node(PlygnMesh.elem{ie}(m+2),1);
    y3 = PlygnMesh.node(PlygnMesh.elem{ie}(m+2),2);
    ar = abs(0.5*((x2-x1).*(y3-y1)-(x3-x1).*(y2-y1)));
    for k=1:NumQuadPts
      qp = GAUSSQUAD.TRIG(k,1) * [x1,y1] ...
         + GAUSSQUAD.TRIG(k,2) * [x2,y2] ...
         + GAUSSQUAD.TRIG(k,3) * [x3,y3] ;
      ExactPres = EqnBC.fxnp(qp);
      perr = ExactPres - NumerPres(ie);
      EmErrPres(ie) = EmErrPres(ie) + GAUSSQUAD.TRIG(k,4) * (perr.^2) * ar;
    end
  end
end
L2ErrPres = sqrt(sum(EmErrPres));

%% Computing other errors 

return;