function [sln] = Stokes_WG_PlygnP02P02CW02P0_AsmSlv( ...
  EqnBC,BndryCondType,PlygnMesh,GAUSSQUAD)
%% Stokes.: WG(P0^2,P0^2;CW0^2,P0): Assembling & Solving on a plygn.mesh 
% In grad-div formulation 
%   Discrete weak gradient:   (P0^2,P0^2) -> CW0^2 
%   Discrete weak divergence: (P0^2,P0^2) -> P0 
% James Liu, ColoState; 2017/07--2019/03 

%% Equation info 
mu = EqnBC.mu;

%% Mesh info 
NumEms = PlygnMesh.NumEms;
NumEgs = PlygnMesh.NumEgs;
maxn = PlygnMesh.maxn;

%% Sorting out boundary edges: 1=Dirichlet, 2=Neumann 
DirichletEdge = find(BndryCondType(PlygnMesh.BndryEdge+1)==1);
NeumannEdge   = find(BndryCondType(PlygnMesh.BndryEdge+1)==2);

%% Boundary info 
NumDirichletEgs = size(DirichletEdge,1);
NumNeumannEgs = size(NeumannEdge,1);

%% Setup 
DOFs = 2*NumEms + 2*NumEgs + NumEms;
DOFsVel = 2*NumEms + 2*NumEgs;
DOFsPres = NumEms;
% GlbMat = sparse(DOFs,DOFs);
% GlbRHS = zeros(DOFs,1);
% sln = zeros(DOFs,1);

%% Computing elementwise matrices: grad-grad 
GM = Hdiv_PlygnCW02_Wachspress_GramMat(PlygnMesh,GAUSSQUAD);
CDWGB = WG_PlygnP02P02CW02_Wachspress_DiscWkGradBasFxn(PlygnMesh,GAUSSQUAD);
EltMatGradGrad = cell(NumEms,1);
for ie=1:NumEms
  n = PlygnMesh.ElemType(ie);
  EltMatGradGrad{ie} = zeros(2+2*n,2+2*n);
  for i=1:(2+2*n)
    for j=1:(2+2*n)
      EltMatGradGrad{ie}(i,j) = 0;
      for k=1:(2*n)
        for l=1:(2*n)
          EltMatGradGrad{ie}(i,j) = EltMatGradGrad{ie}(i,j) ...
              + CDWGB{ie}(i,k) * 0.5*(GM{ie}(k,l)+GM{ie}(k,l)) ...
              * CDWGB{ie}(j,l);
        end
      end
    end
  end
end

%% Reorganzing 
ArrayEE = zeros(NumEms,2,2);
ArrayEG = zeros(NumEms,2,2*maxn);
ArrayGG = zeros(NumEms,2*maxn,2*maxn);
for ie=1:NumEms
  n = PlygnMesh.ElemType(ie);
  EltMat = mu * EltMatGradGrad{ie};
  ArrayEE(ie,1,1) = EltMat(1,1);
  ArrayEE(ie,1,2) = EltMat(1,2);
  ArrayEE(ie,2,1) = EltMat(2,1);
  ArrayEE(ie,2,2) = EltMat(2,2);
  for j=1:n
    ArrayEG(ie,1,2*j-1) = EltMat(1, 2*j+1);
    ArrayEG(ie,1,2*j  ) = EltMat(1, 2*j+2);
    ArrayEG(ie,2,2*j-1) = EltMat(2, 2*j+1);
    ArrayEG(ie,2,2*j  ) = EltMat(2, 2*j+2);
    for i=1:n
      ArrayGG(ie,2*i-1,2*j-1) = EltMat(2*i+1, 2*j+1);
      ArrayGG(ie,2*i-1,2*j  ) = EltMat(2*i+1, 2*j+2);
      ArrayGG(ie,2*i,  2*j-1) = EltMat(2*i+2, 2*j+1);
      ArrayGG(ie,2*i,  2*j  ) = EltMat(2*i+2, 2*j+2);
    end
  end
end

%% Positions 
% NOTE: FACT: Polygon #sides<=maxn 
% Special treatment for edge position (gpos) for assembly 
gpos1 = DOFsVel * ones(NumEms,maxn);
gpos2 = DOFsVel * ones(NumEms,maxn);
for ie=1:NumEms
  n = PlygnMesh.ElemType(ie);
  for m=1:n
    gpos1(ie,m) = 2*NumEms + 2*PlygnMesh.elem2edge{ie}(m)-1;
    gpos2(ie,m) = 2*NumEms + 2*PlygnMesh.elem2edge{ie}(m);
  end
end

%% Assembling 
GlbMatVV = sparse(DOFsVel,DOFsVel);
% Part 1: element-element interaction 
for i=1:2
  II = 2*(0:NumEms-1) + i;
  for j=1:2
    JJ = 2*(0:NumEms-1) + j;
    GlbMatVV = GlbMatVV + sparse(II,JJ, ArrayEE(:,i,j), DOFsVel,DOFsVel);
  end
end
% Part 2: element-edge and edge-element interaction 
for i=1:2
  II = 2*(0:NumEms-1) + i;
  for j=1:maxn
    jj1 = 2*j-1;  JJ1 = gpos1(:,j);
    jj2 = 2*j;    JJ2 = gpos2(:,j);
    GlbMatVV = GlbMatVV + sparse(II,JJ1, ArrayEG(:,i,jj1), DOFsVel,DOFsVel);
    GlbMatVV = GlbMatVV + sparse(II,JJ2, ArrayEG(:,i,jj2), DOFsVel,DOFsVel);
    GlbMatVV = GlbMatVV + sparse(JJ1,II, ArrayEG(:,i,jj1), DOFsVel,DOFsVel);
    GlbMatVV = GlbMatVV + sparse(JJ2,II, ArrayEG(:,i,jj2), DOFsVel,DOFsVel);
  end
end
% Part 3: edge-edge interaction 
for i=1:maxn
  ii1 = 2*i-1;  II1 = gpos1(:,i);
  ii2 = 2*i;    II2 = gpos2(:,i);
  for j=1:maxn
    jj1 = 2*j-1;  JJ1 = gpos1(:,j);
    jj2 = 2*j;    JJ2 = gpos2(:,j);
    GlbMatVV = GlbMatVV + sparse(II1,JJ1,ArrayGG(:,ii1,jj1),DOFsVel,DOFsVel);
    GlbMatVV = GlbMatVV + sparse(II1,JJ2,ArrayGG(:,ii1,jj2),DOFsVel,DOFsVel);
    GlbMatVV = GlbMatVV + sparse(II2,JJ1,ArrayGG(:,ii2,jj1),DOFsVel,DOFsVel);
    GlbMatVV = GlbMatVV + sparse(II2,JJ2,ArrayGG(:,ii2,jj2),DOFsVel,DOFsVel);
  end
end

%% 
CDWDB = WG_PlygnP02P02P0_CofNmlzBas_DiscWkDivBasFxn(PlygnMesh);

%% 
EltMatVP = zeros(NumEms,2+2*maxn);
for ie=1:NumEms
  n = PlygnMesh.ElemType(ie);
  for i=1:(2+2*n)
    EltMatVP(ie,i) = CDWDB{ie}(i) * PlygnMesh.area(ie);
  end
end

%% 
GlbMatVP = sparse(DOFsVel, DOFsPres);
GlbMatPV = sparse(DOFsPres, DOFsVel);
JJ = (1:NumEms);
II1 = 2*(0:NumEms-1) + 1;
II2 = 2*(0:NumEms-1) + 2;
GlbMatVP = GlbMatVP - sparse(II1,JJ,EltMatVP(:,1),DOFsVel,DOFsPres);
GlbMatVP = GlbMatVP - sparse(II2,JJ,EltMatVP(:,2),DOFsVel,DOFsPres);
GlbMatPV = GlbMatPV + sparse(JJ,II1,EltMatVP(:,1),DOFsPres,DOFsVel);
GlbMatPV = GlbMatPV + sparse(JJ,II2,EltMatVP(:,2),DOFsPres,DOFsVel);
for i=1:maxn
  ii1 = 2*i+1;  II1 = gpos1(:,i);
  ii2 = 2*i+2;  II2 = gpos2(:,i);
  GlbMatVP = GlbMatVP - sparse(II1,JJ,EltMatVP(:,ii1),DOFsVel,DOFsPres);
  GlbMatVP = GlbMatVP - sparse(II2,JJ,EltMatVP(:,ii2),DOFsVel,DOFsPres);
  GlbMatPV = GlbMatPV + sparse(JJ,II1,EltMatVP(:,ii1),DOFsPres,DOFsVel);
  GlbMatPV = GlbMatPV + sparse(JJ,II2,EltMatVP(:,ii2),DOFsPres,DOFsVel);
end

%% Putting 4 blocks together
GlbMatPP = sparse(DOFsPres, DOFsPres);
GlbMat = [GlbMatVV, GlbMatVP; ...
          GlbMatPV, GlbMatPP];

%% Assembling GlbRHS 
% Applying the chosen Gaussian quadrature for triangles 
GlbRHS = zeros(DOFs,1);
NumQuadPts = size(GAUSSQUAD.TRIG,1); 
for ie=1:NumEms
  n = PlygnMesh.ElemType(ie);
  fintgrl1 = 0;
  fintgrl2 = 0;
  for m=1:(n-2)
    x1 = PlygnMesh.node(PlygnMesh.elem{ie}(1),1);
    y1 = PlygnMesh.node(PlygnMesh.elem{ie}(1),2);
    x2 = PlygnMesh.node(PlygnMesh.elem{ie}(m+1),1);
    y2 = PlygnMesh.node(PlygnMesh.elem{ie}(m+1),2);
    x3 = PlygnMesh.node(PlygnMesh.elem{ie}(m+2),1);
    y3 = PlygnMesh.node(PlygnMesh.elem{ie}(m+2),2);
    ar = abs(0.5*((x2-x1).*(y3-y1)-(x3-x1).*(y2-y1)));
    for k=1:NumQuadPts
      qp = GAUSSQUAD.TRIG(k,1) * [x1,y1] ...
         + GAUSSQUAD.TRIG(k,2) * [x2,y2] ...
         + GAUSSQUAD.TRIG(k,3) * [x3,y3];
      fval = EqnBC.fxnf(qp);
      fintgrl1 = fintgrl1 + GAUSSQUAD.TRIG(k,4) * fval(1) * ar;
      fintgrl2 = fintgrl2 + GAUSSQUAD.TRIG(k,4) * fval(2) * ar;
    end
  end
  GlbRHS(2*ie-1) = fintgrl1;
  GlbRHS(2*ie  ) = fintgrl2;
end

%% Incorporating boundary conditions: Neumann as natural 
% Working on all these edges simultaneously 
tNavg = zeros(NumNeumannEgs,2);
if NumNeumannEgs>0
  x1 = PlygnMesh.node(PlygnMesh.edge(NeumannEdge,1),1);
  x2 = PlygnMesh.node(PlygnMesh.edge(NeumannEdge,2),1);
  y1 = PlygnMesh.node(PlygnMesh.edge(NeumannEdge,1),2);
  y2 = PlygnMesh.node(PlygnMesh.edge(NeumannEdge,2),2);
  LenEg = sqrt((x1-x2).^2+(y1-y2).^2);
  NumQuadPts = size(GAUSSQUAD.LINE,1);
  for k=1:NumQuadPts
    qp = GAUSSQUAD.LINE(k,1)*[x1,y1] + GAUSSQUAD.LINE(k,2)*[x2,y2];
    tNval = EqnBC.fxntN(qp);
    tNavg(:,1) = tNavg(:,1) + GAUSSQUAD.LINE(k,3)* tNval(:,1);
    tNavg(:,2) = tNavg(:,2) + GAUSSQUAD.LINE(k,3)* tNval(:,2);
  end
  II1 = 2*NumEms + 2*NeumannEdge - 1;
  II2 = 2*NumEms + 2*NeumannEdge;
  GlbRHS(II1) = GlbRHS(II1) - tNavg(:,1).*LenEg;  % NOTE: Negative sign 
  GlbRHS(II2) = GlbRHS(II2) - tNavg(:,2).*LenEg;  % NOTE: Negative sign 
end

%% Incorporating boundary conditions: Dirichlet as essential 
% Assuming NumDirichletEgs>0 
uDavg = zeros(NumDirichletEgs,2);
x1 = PlygnMesh.node(PlygnMesh.edge(DirichletEdge,1),1);
x2 = PlygnMesh.node(PlygnMesh.edge(DirichletEdge,2),1);
y1 = PlygnMesh.node(PlygnMesh.edge(DirichletEdge,1),2);
y2 = PlygnMesh.node(PlygnMesh.edge(DirichletEdge,2),2);
NumQuadPts = size(GAUSSQUAD.LINE,1);
for k=1:NumQuadPts
  qp = GAUSSQUAD.LINE(k,1)*[x1,y1] + GAUSSQUAD.LINE(k,2)*[x2,y2];
  uDval = EqnBC.fxnuD(qp);
  uDavg(:,1) = uDavg(:,1) + GAUSSQUAD.LINE(k,3) * uDval(:,1);
  uDavg(:,2) = uDavg(:,2) + GAUSSQUAD.LINE(k,3) * uDval(:,2);
end

%% For reducing ... 
flag = ones(DOFs,1);
flag(2*NumEms+2*DirichletEdge-1) = zeros(NumDirichletEgs,1);
flag(2*NumEms+2*DirichletEdge  ) = zeros(NumDirichletEgs,1);
EmFreeEgEm = find(flag);

%% Reducing ...
sln = zeros(DOFs,1);
sln(2*NumEms+2*DirichletEdge-1) = uDavg(:,1);
sln(2*NumEms+2*DirichletEdge  ) = uDavg(:,2);
GlbRHS = GlbRHS - GlbMat*sln;

%% Solving the reduced global linear system directly 
sln(EmFreeEgEm) = GlbMat(EmFreeEgEm,EmFreeEgEm) \ GlbRHS(EmFreeEgEm);

return;