function [NumerVelCofP02,NumerPresCofP0] = ... 
  Stokes_WG_PlygnP02P02CW02P0DDF_VelPresDiv( ...
  EqnBC,BndryCondType,PlygnMesh,DDFsln,EltMatVGVG,EltMatConv,GAUSSQUAD)
%% Stokes.: WG(P0^2,P0^2;CW0^2,P0)DDF: 
% Computing elementwise constant velocity and pressure 
% James Liu, ColoState; 2017/07--2019/03 

%% Equation info 
mu = EqnBC.mu;

%% Mesh info 
NumNds = PlygnMesh.NumNds;
NumEms = PlygnMesh.NumEms;
NumEgs = PlygnMesh.NumEgs;
maxn = PlygnMesh.maxn;

%% Extracting elementwise constant velocity 
NumerVelCofP02 = zeros(NumEms,2);
NumerVelCofP02(:,1) = DDFsln(2*(1:NumEms)-1);
NumerVelCofP02(:,2) = DDFsln(2*(1:NumEms)  );

%% Forming matrix sz. NumEgs*NumEms: EgNml vel.bas.fxn. vs em.pres.bas.fxn.
% For edge-element interaction 
EgMat = zeros(NumEgs,2);
j1 = PlygnMesh.edge(:,1);  j2 = PlygnMesh.edge(:,2);
EgCntr = 0.5*(PlygnMesh.node(j1,:) + PlygnMesh.node(j2,:));
% For the 1st elements 
EmCntr = PlygnMesh.EmCntr(PlygnMesh.edge2elem(:,1),:);
dp = dot(EmCntr-EgCntr,PlygnMesh.EgNml,2);
sn = ones(NumEgs,1);  gidx = find(dp<0);  sn(gidx) = -1;
EgMat(:,1) = sn .* PlygnMesh.EgLen;
% For the 2nd elements 
sn = ones(NumEgs,1);
for ig=1:NumEgs
  if (PlygnMesh.edge2elem(ig,2)==0) 
    sn(ig) = 0; 
    continue;
  end
  ec = PlygnMesh.EmCntr(PlygnMesh.edge2elem(ig,2),:);
  tmp = dot(ec-EgCntr(ig,:),PlygnMesh.EgNml(ig,:));
  if (tmp<0)
    sn(ig) = -1;
  end
end
EgMat(:,2) = sn .* PlygnMesh.EgLen;
% Assembly 
GlbMatB = sparse(NumEgs,NumEms);
% For the 1st elements 
II = (1:NumEgs);
JJ = PlygnMesh.edge2elem(:,1);
GlbMatB = GlbMatB + sparse(II,JJ,EgMat(:,1),NumEgs,NumEms);
% For the 2nd elements 
JJ = PlygnMesh.edge2elem(:,2);
gidx = find(JJ==0);  JJ(gidx) = NumEms;  EgMat(gidx,2) = 0;
GlbMatB = GlbMatB + sparse(II,JJ,EgMat(:,2),NumEgs,NumEms);

%% Assembling GlbMatVGVG 
% Reorganzing 
ArrayEE = zeros(NumEms,2,2);
ArrayEG = zeros(NumEms,2,2*maxn);
ArrayGG = zeros(NumEms,2*maxn,2*maxn);
for ie=1:NumEms
  n = PlygnMesh.ElemType(ie);
  EltMat = mu * squeeze(EltMatVGVG(ie,:,:));
  ArrayEE(ie,1,1) = EltMat(1,1);
  ArrayEE(ie,1,2) = EltMat(1,2);
  ArrayEE(ie,2,1) = EltMat(2,1);
  ArrayEE(ie,2,2) = EltMat(2,2);
  for j=1:n
    ArrayEG(ie,1,2*j-1) = EltMat(1, 2*j+1);
    ArrayEG(ie,1,2*j  ) = EltMat(1, 2*j+2);
    ArrayEG(ie,2,2*j-1) = EltMat(2, 2*j+1);
    ArrayEG(ie,2,2*j  ) = EltMat(2, 2*j+2);
    for i=1:n
      ArrayGG(ie,2*i-1,2*j-1) = EltMat(2*i+1, 2*j+1);
      ArrayGG(ie,2*i-1,2*j  ) = EltMat(2*i+1, 2*j+2);
      ArrayGG(ie,2*i,  2*j-1) = EltMat(2*i+2, 2*j+1);
      ArrayGG(ie,2*i,  2*j  ) = EltMat(2*i+2, 2*j+2);
    end
  end
end
% Positions 
% NOTE: FACT: Polygon #sides<=maxn 
% Special treatment for edge position (gpos) for assembly 
DOFsVel = 2*NumEms + 2*NumEgs;
gpos1 = DOFsVel * ones(NumEms,maxn);
gpos2 = DOFsVel * ones(NumEms,maxn);
for ie=1:NumEms
  n = PlygnMesh.ElemType(ie);
  for m=1:n
    gpos1(ie,m) = 2*NumEms + 2*PlygnMesh.elem2edge{ie}(m)-1;
    gpos2(ie,m) = 2*NumEms + 2*PlygnMesh.elem2edge{ie}(m);
  end
end
% Assembling 
GlbMatVGVG = sparse(DOFsVel,DOFsVel);
% Part 1: element-element interaction 
for i=1:2
  II = 2*(0:NumEms-1) + i;
  for j=1:2
    JJ = 2*(0:NumEms-1) + j;
    GlbMatVGVG = GlbMatVGVG + sparse(II,JJ, ArrayEE(:,i,j), DOFsVel,DOFsVel);
  end
end
% Part 2: element-edge and edge-element interaction 
for i=1:2
  II = 2*(0:NumEms-1) + i;
  for j=1:maxn
    jj1 = 2*j-1;  JJ1 = gpos1(:,j);
    jj2 = 2*j;    JJ2 = gpos2(:,j);
    GlbMatVGVG = GlbMatVGVG + sparse(II,JJ1, ArrayEG(:,i,jj1), DOFsVel,DOFsVel);
    GlbMatVGVG = GlbMatVGVG + sparse(II,JJ2, ArrayEG(:,i,jj2), DOFsVel,DOFsVel);
    GlbMatVGVG = GlbMatVGVG + sparse(JJ1,II, ArrayEG(:,i,jj1), DOFsVel,DOFsVel);
    GlbMatVGVG = GlbMatVGVG + sparse(JJ2,II, ArrayEG(:,i,jj2), DOFsVel,DOFsVel);
  end
end
% Part 3: edge-edge interaction 
for i=1:maxn
  ii1 = 2*i-1;  II1 = gpos1(:,i);
  ii2 = 2*i;    II2 = gpos2(:,i);
  for j=1:maxn
    jj1 = 2*j-1;  JJ1 = gpos1(:,j);
    jj2 = 2*j;    JJ2 = gpos2(:,j);
    GlbMatVGVG = GlbMatVGVG + sparse(II1,JJ1,ArrayGG(:,ii1,jj1),DOFsVel,DOFsVel);
    GlbMatVGVG = GlbMatVGVG + sparse(II1,JJ2,ArrayGG(:,ii1,jj2),DOFsVel,DOFsVel);
    GlbMatVGVG = GlbMatVGVG + sparse(II2,JJ1,ArrayGG(:,ii2,jj1),DOFsVel,DOFsVel);
    GlbMatVGVG = GlbMatVGVG + sparse(II2,JJ2,ArrayGG(:,ii2,jj2),DOFsVel,DOFsVel);
  end
end

%% Converting DDFsln to Vsln
Vsln = zeros(2*NumEms+2*NumEgs,1);
% For element interiors 
Vsln(1:2*NumEms) = DDFsln(1:2*NumEms);
% For edge tangentials 
Vsln(2*NumEms+2*(1:NumEgs)-1) = DDFsln(2*NumEms+(1:NumEgs)) .* PlygnMesh.EgTan(:,1);
Vsln(2*NumEms+2*(1:NumEgs)  ) = DDFsln(2*NumEms+(1:NumEgs)) .* PlygnMesh.EgTan(:,2);
% For edge normals 
for id=1:NumNds
  for jg=1:PlygnMesh.NumConnEgsNd(id)
    kg = PlygnMesh.NdConnEg{id}(jg);
    sn = PlygnMesh.NdEgConnSign(id,kg);
    ln = PlygnMesh.EgLen(kg);
    Vsln(2*NumEms+2*kg-1) = Vsln(2*NumEms+2*kg-1) + (sn*ln)*DDFsln(2*NumEms+NumEgs+id)*PlygnMesh.EgNml(kg,1);
    Vsln(2*NumEms+2*kg  ) = Vsln(2*NumEms+2*kg  ) + (sn*ln)*DDFsln(2*NumEms+NumEgs+id)*PlygnMesh.EgNml(kg,2);
  end
end

%% 
uh = GlbMatVGVG * Vsln;

%% Preparing ... 
uhvh = zeros(NumEgs,1);
for ig=1:NumEgs
  uhvh(ig) = uh(2*NumEms+2*ig-1) * PlygnMesh.EgNml(ig,1)...
           + uh(2*NumEms+2*ig  ) * PlygnMesh.EgNml(ig,2);
end
% uhvh = PlygnMesh.EgLen;

%% Recovering elementwise constant pressure 
% sln(2*NumEms+2*NumEgs+(1:NumEms)) store emws. pressure 
NumerPresCofP0 = GlbMatB \ (-uhvh);  % NOTE negative 
% NumerPresCofP0 = zeros(NumEms,1);

return;