% function [sln,GlbMatRed,GlbMat,pos,EltMatDDF,EltMatVGVG,EltMatConv] = ... 
function [sln,EltMatVGVG,EltMatConv] = ... 
  Stokes_WG_PlygnP02P02CW02P0DDF_AsmSlv(... 
  EqnBC,BndryCondType,PlygnMesh,GAUSSQUAD)
%% Stokes: WG(P0^2,P0^2;CW0^2,P0)DDF: Assembling & Solving on a plygn.mesh 
% The scheme using the discretely div-free (DDF) subspace 
% James Liu, ColoState; 2017/07--2019/03 

%% Equation info 
mu = EqnBC.mu;

%% Mesh info 
NumNds = PlygnMesh.NumNds;
NumEms = PlygnMesh.NumEms;
NumEgs = PlygnMesh.NumEgs;
maxn = PlygnMesh.maxn;

%% Sorting out boundary edges: 1=Dirichlet, 2=Neumann 
DirichletEdge = find(BndryCondType(PlygnMesh.BndryEdge+1)==1);
NeumannEdge   = find(BndryCondType(PlygnMesh.BndryEdge+1)==2);

%% Boundary info 
NumDirichletEgs = size(DirichletEdge,1);
NumNeumannEgs = size(NeumannEdge,1);

%% JL20190328: TO BE REVISED FOR EFFICIENCY !
DirichletNodeFlag = zeros(NumNds,1);
for ig=1:NumDirichletEgs
  k1 = PlygnMesh.edge(DirichletEdge(ig),1);
  k2 = PlygnMesh.edge(DirichletEdge(ig),2);
  DirichletNodeFlag(k1) = 1;
  DirichletNodeFlag(k2) = 1;
end
DirichletNode = find(DirichletNodeFlag);
NumDirichletNds = sum(DirichletNodeFlag);

%% Setup for DDF 
DOFs = 2*NumEms + NumEgs + NumNds;
GlbMatDDF = sparse(DOFs,DOFs);

%% Computing element stiffness matrices for all velocity basis functions 
% Using natural basis functions: 2 for interior, 2*n for edges 
% FACT: For each polygon: #edges<=maxn, #nodes<=maxn 
GM = Hdiv_PlygnCW02_Wachspress_GramMat(PlygnMesh,GAUSSQUAD);
CDWGB = WG_PlygnP02P02CW02_Wachspress_DiscWkGradBasFxn(PlygnMesh,GAUSSQUAD);
EltMatVGVG = zeros(NumEms, 2+2*maxn, 2+2*maxn);
for ie=1:NumEms
  n = PlygnMesh.ElemType(ie);
  for i=1:(2+2*n)
    for j=1:(2+2*n)
      % EltMatVGVG(ie,i,j) = 0;
      for k=1:(2*n)
        for l=1:(2*n)
          EltMatVGVG(ie,i,j) = EltMatVGVG(ie,i,j) ...
              + CDWGB{ie}(i,k) * GM{ie}(k,l) * CDWGB{ie}(j,l);
        end
      end
    end
  end
end

%% Establishing elementwise conversion matrix 
EltMatConv = zeros(NumEms,2+2*maxn,2+2*maxn);
% For interior basis functions 
EltMatConv(:,1,1) = 1;  
EltMatConv(:,2,2) = 1;
% For edge tangential basis functions 
for ie=1:NumEms
  n = PlygnMesh.ElemType(ie);
  for j=1:n 
    k = PlygnMesh.elem2edge{ie}(j);
    EltMatConv(ie,2+j,2+2*j-1) = PlygnMesh.EgTan(k,1);
    EltMatConv(ie,2+j,2+2*j  ) = PlygnMesh.EgTan(k,2);
  end
end
% For nodal basis functions 
for ie=1:NumEms
  n = PlygnMesh.ElemType(ie);
  for j=1:n 
    jd = PlygnMesh.elem{ie}(j);
    j1 = j;
    jg1 = PlygnMesh.elem2edge{ie}(j1);
    ln1 = PlygnMesh.EgLen(jg1);
    sn1 = PlygnMesh.NdEgConnSign(jd,jg1);
    j2 = j - 1;
    if (j==1) 
      j2 = n; 
    end
    jg2 = PlygnMesh.elem2edge{ie}(j2);
    ln2 = PlygnMesh.EgLen(jg2);
    sn2 = PlygnMesh.NdEgConnSign(jd,jg2);
    EltMatConv(ie,2+n+j,2+2*j1-1) = sn1*ln1 * PlygnMesh.EgNml(jg1,1);
    EltMatConv(ie,2+n+j,2+2*j1  ) = sn1*ln1 * PlygnMesh.EgNml(jg1,2);
    EltMatConv(ie,2+n+j,2+2*j2-1) = sn2*ln2 * PlygnMesh.EgNml(jg2,1);
    EltMatConv(ie,2+n+j,2+2*j2  ) = sn2*ln2 * PlygnMesh.EgNml(jg2,2);
  end
end

%% JL20190313: The most delicate/difficult part: Consolidation 
%% Converting EltMatVGVG to EltMatDDF for disc.div-free bases 
EltMatDDF = zeros(NumEms, 2+2*maxn, 2+2*maxn);
for ie=1:NumEms
  n = PlygnMesh.ElemType(ie);
  for i=1:(2+2*n)
    for j=1:(2+2*n)
      EltMatDDF(ie,i,j) = 0;
      for k=1:(2+2*n)
        for l=1:(2+2*n)
          EltMatDDF(ie,i,j) = EltMatDDF(ie,i,j) ...
            + EltMatConv(ie,i,k) * EltMatVGVG(ie,k,l) * EltMatConv(ie,j,l);
        end
      end
    end
  end
end

%% Positions: Organized elementwise: 2 interiors, n edges, n nodes 
pos = DOFs * ones(NumEms,2+2*maxn);
for ie=1:NumEms
  pos(ie,1) = 2*ie - 1;
  pos(ie,2) = 2*ie;
  n = PlygnMesh.ElemType(ie);
  for m=1:n  % Treating edges and nodes in one loop 
    pos(ie,2+m) = 2*NumEms + PlygnMesh.elem2edge{ie}(m);
    pos(ie,2+n+m) = 2*NumEms + NumEgs + PlygnMesh.elem{ie}(m);
  end
end

%% Assembling the consolidated elementwise stiffness matrices (EltMatDDF)
for i=1:(2+2*maxn)
  II = pos(:,i);
  for j=1:(2+2*maxn)
    JJ = pos(:,j);
    GlbMatDDF = GlbMatDDF + sparse(II,JJ,EltMatDDF(:,i,j),DOFs,DOFs);
  end
end

%% Assembling GlbRHS 
% Applying the chosen Gaussian quadrature for triangles 
GlbRHS = zeros(DOFs,1);
NumQuadPts = size(GAUSSQUAD.TRIG,1); 
for ie=1:NumEms
  n = PlygnMesh.ElemType(ie);
  fintgrl1 = 0;
  fintgrl2 = 0;
  for m=1:(n-2)
    x1 = PlygnMesh.node(PlygnMesh.elem{ie}(1),1);
    y1 = PlygnMesh.node(PlygnMesh.elem{ie}(1),2);
    x2 = PlygnMesh.node(PlygnMesh.elem{ie}(m+1),1);
    y2 = PlygnMesh.node(PlygnMesh.elem{ie}(m+1),2);
    x3 = PlygnMesh.node(PlygnMesh.elem{ie}(m+2),1);
    y3 = PlygnMesh.node(PlygnMesh.elem{ie}(m+2),2);
    ar = abs(0.5*((x2-x1).*(y3-y1)-(x3-x1).*(y2-y1)));
    for k=1:NumQuadPts
      qp = GAUSSQUAD.TRIG(k,1) * [x1,y1] ...
         + GAUSSQUAD.TRIG(k,2) * [x2,y2] ...
         + GAUSSQUAD.TRIG(k,3) * [x3,y3];
      fval = EqnBC.fxnf(qp);
      fintgrl1 = fintgrl1 + GAUSSQUAD.TRIG(k,4) * fval(1) * ar;
      fintgrl2 = fintgrl2 + GAUSSQUAD.TRIG(k,4) * fval(2) * ar;
    end
  end
  GlbRHS(2*ie-1) = fintgrl1;
  GlbRHS(2*ie  ) = fintgrl2;
end

%% For reducing ... 
flag = ones(DOFs,1);
flag(2*NumEms+DirichletEdge) = zeros(NumDirichletEgs,1);
flag(2*NumEms+NumEgs+DirichletNode) = zeros(NumDirichletNds,1);
EmFreeEgNd = find(flag);

%% Reducing ...
sln = zeros(DOFs,1);
sln(2*NumEms+DirichletEdge) = 0;  % Temporarily for homo.DirichletB.C. 
sln(2*NumEms+NumEgs+DirichletNode) = 0;  % Temporarily for homo.DirichletB.C. 
GlbRHS = GlbRHS - GlbMatDDF*sln;

%% Solving the reduced global linear system directly 
sln(EmFreeEgNd) = GlbMatDDF(EmFreeEgNd,EmFreeEgNd) \ GlbRHS(EmFreeEgNd);
% GlbMatRed = GlbMatDDF(EmFreeEgNd,EmFreeEgNd);

return;