%% RectangleMinusCircle.m 
% For use with PolyMesher (adopted with modification) 
% Graham Harper, James Liu, ColoState; 2012/07--2019/03 

%------------------------------ PolyMesher -------------------------------%
% Ref: C Talischi, GH Paulino, A Pereira, IFM Menezes, "PolyMesher: A     %
%      general-purpose mesh generator for polygonal elements written in   %
%      Matlab," Struct Multidisc Optim, DOI 10.1007/s00158-011-0706-z     %
%-------------------------------------------------------------------------%

function [x] = RectangleMinusCircle(Demand,Arg)
  BdBox = [0 2 0 1];  % JL20190326: To be changed to a rectangle 
  Center = [0.5, 0.5];
  Radius = 0.1;
  switch(Demand)
    case('Dist');  x = DistFnc(Arg,BdBox,Center,Radius);
    case('BC');    x = BndryCnds(Arg{:},BdBox,Center,Radius);
    case('BdBox'); x = BdBox;
    case('PFix');  x = FixedPoints(BdBox);
  end
%----------------------------------------------- COMPUTE DISTANCE FUNCTIONS
function Dist = DistFnc(P,BdBox,Center,Radius)
  dR = dRectangle(P,BdBox(1),BdBox(2),BdBox(3),BdBox(4));
  dC = -dCircle(P,Center(1),Center(2),Radius);
  Dist = dIntersect(dR,dC);
%---------------------------------------------- SPECIFY BOUNDARY CONDITIONS
function [x] = BndryCnds(Node,Element,BdBox,Center,Radius)
  eps = 0.1*sqrt((BdBox(2)-BdBox(1))*(BdBox(4)-BdBox(3))/size(Node,1));
  LeftEdgeNodes = find(abs(Node(:,1)-BdBox(1))<eps);
  LeftUpperNode = find(abs(Node(:,1)-BdBox(1))<eps & ...
                       abs(Node(:,2)-BdBox(4))<eps);
  RigthBottomNode = find(abs(Node(:,1)-BdBox(2))<eps & ...
                         abs(Node(:,2)-BdBox(3))<eps);
  CircleNode = find( abs( (Node(:,1)-Center(1)).^2 + (Node(:,2)-Center(2)).^2 - Radius^2) < eps);
  FixedNodes = [LeftEdgeNodes; RigthBottomNode; CircleNode];
  Supp = zeros(length(FixedNodes),3);
  Supp(:,1)=FixedNodes; Supp(1:end-1,2)=1; Supp(end,3)=1;
  Load = [LeftUpperNode,0,-0.5];
  x = {Supp,Load};
%----------------------------------------------------- SPECIFY FIXED POINTS
function [PFix] = FixedPoints(BdBox)
  PFix = [];
%-------------------------------------------------------------------------%