%% JL20190326: TO BE REVISED FOR more general cases 
function PlygnMesh = PlygnMesh_Enrich6(PlygnMesh,BndryDescMat)
%% Enriching a polygonal mesh converted from PolyMesher 
% Graham Harper, James Liu, ColoState; 2012/07--2019/03 

%%
NumEgs = PlygnMesh.NumEgs;
PlygnMesh.BndryEdge = zeros(NumEgs,1);
for ig=1:NumEgs 
  % Utilizing the info obtained the above 
  % PlygnMesh.edge2elem(ig,2)>0 if it is an interior edge 
  if PlygnMesh.edge2elem(ig,2)>0 
    continue;
  end
  % Assuming now RectMesh.edge2elem(2,jg)==0 
  x1 = PlygnMesh.node(PlygnMesh.edge(ig,1),1);
  x2 = PlygnMesh.node(PlygnMesh.edge(ig,2),1);
  y1 = PlygnMesh.node(PlygnMesh.edge(ig,1),2);
  y2 = PlygnMesh.node(PlygnMesh.edge(ig,2),2);
  % Screening 
  for k=1:size(BndryDescMat,1)  % Number of segments on the boundary
    X1 = BndryDescMat(k,1);  Y1 = BndryDescMat(k,2);  % Starting point
    X2 = BndryDescMat(k,3);  Y2 = BndryDescMat(k,4);  % Ending point
    if abs((x1-X1)*(Y2-Y1)-(X2-X1)*(y1-Y1))<1e-9 && ... 
       abs((x2-X1)*(Y2-Y1)-(X2-X1)*(y2-Y1))<1e-9 
      PlygnMesh.BndryEdge(ig) = k;
      break;
    end
  end
  % check if (x1-0.5)^2 + (y1-0.5)^2 = 0.1^2
  %   and if (x2-0.5)^2 + (y2-0.5)^2 = 0.1^2
  if abs( sum(([x1,x2,y1,y2]-0.5).^2) - 2*0.1^2 )<0.02  % this tolerance needs to be large for a coarse mesh, small for a fine mesh
      PlygnMesh.BndryEdge(ig) = 4;  % assign boundary type to same as left edge for now
  end
end

return;