%% JL20190327: BEING REVISED 
function [PlygnMesh] = PlygnMesh_Enrich5(PlygnMesh)
%% Enriching a polygonal mesh: 
% Info on nodes versus its neighboring edges and nodes 
% James Liu, ColoState; 2012/07--2019/03 

%% Mesh info 
NumNds = PlygnMesh.NumNds;
NumEgs = PlygnMesh.NumEgs;

%% Generating tertiary mesh info based on PlygnMesh.edge 
% Each node vs. its connecting edges & nodes (no itself)
NumConnEgsNd = zeros(NumNds,1);
% 1st round: counting  
for ig=1:NumEgs
  id1 = PlygnMesh.edge(ig,1);
  id2 = PlygnMesh.edge(ig,2);
  NumConnEgsNd(id1) = NumConnEgsNd(id1) + 1;
  NumConnEgsNd(id2) = NumConnEgsNd(id2) + 1;
end
NdConnEg = cell(NumNds,1);
NdConnNd = cell(NumNds,1);
for id=1:NumNds
  NdConnEg{id} = zeros(1, NumConnEgsNd(id));
  NdConnNd{id} = zeros(1, NumConnEgsNd(id));
end
% 2nd round: filling the spots 
NumConnEgsNd = zeros(NumNds,1);
for ig=1:NumEgs
  id1 = PlygnMesh.edge(ig,1);
  id2 = PlygnMesh.edge(ig,2);
  NumConnEgsNd(id1) = NumConnEgsNd(id1) + 1;
  NumConnEgsNd(id2) = NumConnEgsNd(id2) + 1;
  NdConnEg{id1}(NumConnEgsNd(id1)) = ig;
  NdConnEg{id2}(NumConnEgsNd(id2)) = ig;
  NdConnNd{id1}(NumConnEgsNd(id1)) = id2;
  NdConnNd{id2}(NumConnEgsNd(id2)) = id1;
end

%% Determining signs for connecting node-edges 
% NdConnEgSign = cell(NumNds,1);
NdEgConnSign = sparse(NumNds,NumEgs);
for id=1:NumNds
  % NdConnEgSign{id} = zeros(1,NumConnEgsNd(id));
  for ig=1:NumConnEgsNd(id)
    jd = NdConnNd{id}(ig);
    tmpx = PlygnMesh.node(jd,1) - PlygnMesh.node(id,1);
    tmpy = PlygnMesh.node(jd,2) - PlygnMesh.node(id,2);
    tmp = sqrt(tmpx^2+tmpy^2);
    NmlLcl = [-tmpy/tmp, tmpx/tmp];
    jg = NdConnEg{id}(ig);
    NmlGlb = PlygnMesh.EgNml(jg,:);
    dp = dot(NmlLcl,NmlGlb);
    if (dp>0) 
      % NdConnEgSign{id}(ig) = 1; 
      NdEgConnSign(id,jg) = 1;
    end
    if (dp<0) 
      % NdConnEgSign{id}(ig) = -1; 
      NdEgConnSign(id,jg) = -1;
    end
    % if (dp==0) something is wrong 
  end
end

%% Finishing up 
PlygnMesh.NdConnEg = NdConnEg;
PlygnMesh.NdConnNd = NdConnNd;
PlygnMesh.NumConnEgsNd = NumConnEgsNd;
PlygnMesh.NdEgConnSign = NdEgConnSign;

return;