%% JL20190326: TO BE REVISED FOR EFFICIENCY 
function [PlygnMesh] = PlygnMesh_Enrich3(PlygnMesh,BndryDescMat)
%% Enriching a polygonal mesh with edge length, tangential, normal 
% James Liu, ColoState; 2012/07--2019/03 

%% Mesh info 
NumEgs = PlygnMesh.NumEgs;

%% Computing (meshwise) edge length, tangential, and then normal 
PlygnMesh.EgLen = zeros(NumEgs,1);
PlygnMesh.EgNml = zeros(NumEgs,2);
PlygnMesh.EgTan = zeros(NumEgs,2);
% First length and tangential together 
k1 = PlygnMesh.edge(:,1);
k2 = PlygnMesh.edge(:,2);
tmpx = PlygnMesh.node(k2,1) - PlygnMesh.node(k1,1);
tmpy = PlygnMesh.node(k2,2) - PlygnMesh.node(k1,2);
tmp = sqrt(tmpx.^2+tmpy.^2);
PlygnMesh.EgLen = tmp;
PlygnMesh.EgTan = [tmpx./tmp, tmpy./tmp];
% Rotation (counterclockwise) for tangential to normal 
PlygnMesh.EgNml(:,1) =  PlygnMesh.EgTan(:,2);
PlygnMesh.EgNml(:,2) = -PlygnMesh.EgTan(:,1);

%% Correcting normal vectors for boundary edges 
for ig=1:NumEgs 
  if (PlygnMesh.BndryEdge(ig)==0)
    continue;
  end
  PlygnMesh.EgNml(ig,1) = BndryDescMat(PlygnMesh.BndryEdge(ig),5);
  PlygnMesh.EgNml(ig,2) = BndryDescMat(PlygnMesh.BndryEdge(ig),6);
end

return;