function PlygnMesh = PlygnMesh_ConvFrom_QuadriMesh(QuadriMesh)
%% Polygonal mesh converted from a quadrilateral mesh 
% James Liu, ColoState; 2012/07--2017/08 

%% 
PlygnMesh.NumNds = QuadriMesh.NumNds;
PlygnMesh.NumEms = QuadriMesh.NumEms;

%% 
PlygnMesh.node = QuadriMesh.node;

%% 
PlygnMesh.ElemType = 4*ones(PlygnMesh.NumEms,1);

%% 
PlygnMesh.elem = cell(PlygnMesh.NumEms,1);
for ie=1:PlygnMesh.NumEms
  PlygnMesh.elem{ie} = QuadriMesh.elem(ie,1:4);
end

return;