function ConvMat = Hdiv_PlygnCW0_Wachspress_ConvMatBasFrm(PlygnMesh)
%% Hdiv: CW0 elements on plygn.mesh: Conversion mat. between basis & frame
% See Chen,Wang, Math. Comput., 2017, p.2060 formula (3.2) 
% James Liu, Zhuoran Wang, ColoState; 2012/07--2017/08 

%% Mesh info 
NumEms = PlygnMesh.NumEms;

%% All computation led to the conversion matrix 
% Using polygon (geometric) center as the reference point 
% See ChenWang_MCOM_2017, Lemma 3.1 (p.2060) 
ConvMat = cell(NumEms,1);
for ie=1:NumEms
  n = PlygnMesh.ElemType(ie);
  xc = PlygnMesh.EmCntr(ie,1);
  yc = PlygnMesh.EmCntr(ie,2);
  % Lengths of edges and areas of sub-triangles
  LenEg = zeros(n,1);
  AreaSub = zeros(n,1);
  for i=1:n
    i1 = mod(i,n) + 1;
    x1 = PlygnMesh.node(PlygnMesh.elem{ie}(i),1);
    y1 = PlygnMesh.node(PlygnMesh.elem{ie}(i),2);
    x2 = PlygnMesh.node(PlygnMesh.elem{ie}(i1),1);
    y2 = PlygnMesh.node(PlygnMesh.elem{ie}(i1),2);
    LenEg(i) = sqrt((x2-x1)^2+(y2-y1)^2);
    AreaSub(i) = abs(0.5*((x1-xc)*(y2-yc)-(x2-xc)*(y1-yc)));
  end
  % Coefficiants a 
  cofa = zeros(n,1);
  for i=1:n
    cofa(i) = LenEg(i)./(2*PlygnMesh.area(ie));
  end
  % Coefficiants b 
  cofb = zeros(n,n);
  for i=1:n
    cofb(i,i) = LenEg(i);
  end
  for i=1:n
    for j=1:n 
      cofb(i,j) = cofb(i,j) - LenEg(i)*AreaSub(j)/PlygnMesh.area(ie);
    end
  end
  % Coefficiants c 
  cofc = zeros(n,n);
  for i=1:n
    for j=1:n
      tmp = 0;
      for k=1:(n-1)
        ind = mod(j+k-1,n) + 1;
        tmp = tmp + k*cofb(i,ind);
      end
      cofc(i,j) = -tmp/n;
    end
  end
  % Now the conversion matrix 
  ConvMat{ie} = zeros(n,n+1);
  for i=1:n
    ConvMat{ie}(i,1) = cofa(i);
    for j=1:n
      ConvMat{ie}(i,1+j) = cofc(i,j);
    end
  end  
end

return;