%% TO BE REVISED/VERIFIED BY Graham 
function GM = Hdiv_PlygnCW02_Wachspress_GramMat(PlygnMesh,GAUSSQUAD)
%% "Hdiv" local CW0^2 on polygnal mesh: Gram matrix 
% James Liu, Graham Harper, ColoState; 2017/07--2017/08 

%% Mesh info 
NumEms = PlygnMesh.NumEms; 

%% Gram matrix for CW0 
GMCW0 = Hdiv_PlygnCW0_Wachspress_GramMat(PlygnMesh,GAUSSQUAD);

%% Gram matrix for CW0^2 
GM = cell(NumEms,1);
for ie=1:NumEms
  n = PlygnMesh.ElemType(ie);
  GM{ie} = zeros(2*n,2*n);
  GM{ie}(1:2:(2*n-1), 1:2:(2*n-1)) = GMCW0{ie};
  GM{ie}(2:2:(2*n),   2:2:(2*n))   = GMCW0{ie};
end

return;