function EqnBC = EqnBC_Stokes_SwirlingVelocity 
%% EqnBC: Stokes flow: A swirling velocity with prescribed pressure 
% See LeVeq_SINUM_1996, Assuming mu=1 for now 
% James Liu, ColoState; 2013/04--2018/10 

% Parameters 
mu = 1; 

EqnBC = struct('mu',mu, ...
  'fxnf',@fxnf, 'fxnuD',@fxnuD, ...
  'fxnu',@fxnu, 'fxnug',@fxnug, 'fxnp',@fxnp);

% Body force 
function f = fxnf(pt)
  x = pt(:,1);  y = pt(:,2);
  f1 = 4*pi^2 * (sin(pi*x)).^2 .* sin(2*pi*y);
  f2 = -4*pi^2*sin(2*pi*x).*(sin(pi*y)).^2 + 4*pi^2*sin(2*pi*x).*cos(2*pi*y);
  f = [f1,f2];
end

% Dirichlet boundary condition
function uD = fxnuD(pt)
  % x = pt(:,1);  y = pt(:,2);
  uD = fxnu(pt);
end

% Known exact velocity
function u = fxnu(pt)
  x = pt(:,1);  y = pt(:,2);
  u = [(sin(pi*x)).^2.*sin(2*pi*y), -sin(2*pi*x).*(sin(pi*y)).^2];
end

% Known exact velocity gradient
function ug = fxnug(pt) 
  x = pt(:,1);  y = pt(:,2);
  u1x = pi*sin(2*pi*x).*sin(2*pi*y);
  u1y = 2*pi*sin(pi*x).*sin(pi*x).*cos(2*pi*y);
  u2x = -2*pi*cos(2*pi*x).*sin(pi*y).*sin(pi*y);
  u2y = -pi*sin(2*pi*x).*sin(2*pi*y);
  ug = [u1x, u1y, u2x, u2y];
end
     
% Known exact pressure 
function p = fxnp(pt)
  x = pt(:,1);  y = pt(:,2);
  p = pi*sin(2*pi*x).*sin(2*pi*y);
end

end