function EqnBC = EqnBC_Stokes_LidDrivenCavity 
%% EqnBC: Stokes flow: The widely tested lid-driven cavity
% Assuming mu=1 for now
% James Liu, ColoState; 2013/04--2018/10 

% Parameters 
mu = 1; 

EqnBC = struct('mu',mu, ...
  'fxnf',@fxnf, 'fxnuD', @fxnuD,...
  'fxnu', @fxnu, 'fxnug',@fxnug, 'fxnp', @fxnp);

% Body force 
function f = fxnf(pt)
  f = zeros(size(pt));
end

% Dirichlet boundary conditions 
function uD = fxnuD(pt)
  x = pt(:,1);  y = pt(:,2);
  uD = zeros(size(pt));
  idx = (y==1);
  uD(idx,1) = 1;
end

% No known exact velocity (so set to 0) 
function u = fxnu(pt)
  u = zeros(size(pt));
end

% No known exact velocity gradient (so set to 0) 
function ug = fxnug(pt) 
  x = pt(:,1);  % y = pt(:,2);
  u1x = zeros(size(x));
  u1y = zeros(size(x));
  u2x = zeros(size(x));
  u2y = zeros(size(x));
  ug = [u1x, u1y, u2x, u2y];
end

% No known exact pressure (so set to 0) 
function p = fxnp(pt)
  x = pt(:,1);  % y = pt(:,2);
  p = zeros(size(x));
end

end