%% JL20190326: BEING REVISED 
function EqnBC = EqnBC_Stokes_FlowPassCylinder
% Graham Harper, James Liu, ColoState; 2014/04--2019/03 

% Parameters 
mu = 1; 

EqnBC = struct('mu',mu, ...
  'fxnf',@fxnf, 'fxnuD',@fxnuD, ...
  'fxnu',@fxnu, 'fxnug',@fxnug, 'fxnp',@fxnp);

% Body force 
function f = fxnf(pt)
  x = pt(:,1);  y = pt(:,2);
  f1 = zeros(size(x));
  f2 = zeros(size(x));
  f = [f1,f2];
end

% Dirichlet boundary condition
function uD = fxnuD(pt)
  x = pt(:,1);  y = pt(:,2);
  uD = zeros(size(pt));
  idx0 = (abs(x-0)<1e-9);  % Left boundary  x=0 
  idx1 = (abs(x-2)<1e-9);  % Right boundary x=2 
  uD(idx0,1) = 1;
  uD(idx1,1) = 1;
end

% Known exact velocity
function u = fxnu(pt)
  x = pt(:,1);  y = pt(:,2);
  u = zeros(size(pt));
end

% Known exact velocity gradient
function ug = fxnug(pt) 
  x = pt(:,1);  y = pt(:,2);
  u1x = zeros(size(x));
  u1y = zeros(size(x));
  u2x = zeros(size(x));
  u2y = zeros(size(x));
  ug = [u1x, u1y, u2x, u2y];
end
     
% Known exact pressure 
function p = fxnp(pt)
  x = pt(:,1);  y = pt(:,2);
  p = zeros(size(x));
end

end