function QuadriMesh = DomFOBS_QuadriMesh_GenInit()
%% Domain for Stokes Flow Over Back Step: (-1,5)x(-1,1)\(-1,0)^2 
% Generating an initial quadrilateral mesh with 9 elements, 17 nodes 
% James Liu, ColoState; 2012/07--2019/03 

%% The initial mesh 
NumNds = 17; 
NumEms = 9;
node = [-1, 1;  0, 1;  1, 1;  2, 1;  3, 1;  5, 1; ... 
        -1, 0;  0, 0;  1, 0;  2, 0;  3, 0;  5, 0; ...
                0,-1;  1,-1;  2,-1;  3,-1;  5,-1];
elem = [7 8 2 1;  8 9 3 2;  9 10 4 3;  10 11 5 4;  11 12 6 5; ...
        13 14 9 8;  14 15 10 9;  15 16 11 10;  16 17 12 11];
% 
QuadriMesh.NumNds = NumNds;
QuadriMesh.NumEms = NumEms;
QuadriMesh.node = node;
QuadriMesh.elem = elem;
QuadriMesh.flag = 1;

%% Auxiliary info: node-node to element 
% LblVrtx = zeros(1,4);
NodeElem = sparse(NumNds,NumNds);
for ie=1:NumEms
  LblVrtx = QuadriMesh.elem(ie,1:4);
  NodeElem(LblVrtx(1),LblVrtx(2)) = ie;
  NodeElem(LblVrtx(2),LblVrtx(3)) = ie;
  NodeElem(LblVrtx(3),LblVrtx(4)) = ie;
  NodeElem(LblVrtx(4),LblVrtx(1)) = ie;
end

%% Auxiliary info: node-node to edge 
[I,J] = find(triu(NodeElem+NodeElem'));
NumEgs = size(I,1);
NodeEdge = sparse(I,J,[1:NumEgs],NumNds,NumNds); 
NodeEdge = NodeEdge + NodeEdge';

%% Secondary mesh info: edge vs its 2 nodes 
% Note: start-node label < end-node label, since obtained from "triu" 
QuadriMesh.edge = [I,J];
QuadriMesh.NumEgs = size(QuadriMesh.edge,1);

%% Secondary mesh info: edge vs its 2 neighboring elements 
% LblVrtx = zeros(1,2);
QuadriMesh.edge2elem = zeros(NumEgs,2);
for ig=1:NumEgs
  LblVrtx = QuadriMesh.edge(ig,1:2);
  QuadriMesh.edge2elem(ig,1) = NodeElem(LblVrtx(1),LblVrtx(2));
  QuadriMesh.edge2elem(ig,2) = NodeElem(LblVrtx(2),LblVrtx(1));
end
% Adjusting so that node#1label < node#2label 
ig = find(QuadriMesh.edge2elem(:,1)>QuadriMesh.edge2elem(:,2));
tmp = QuadriMesh.edge2elem(ig,1);
QuadriMesh.edge2elem(ig,1) = QuadriMesh.edge2elem(ig,2);
QuadriMesh.edge2elem(ig,2) = tmp;
% Adjusting for boundary edges 
ig = find(QuadriMesh.edge2elem(:,1)==0);
QuadriMesh.edge2elem(ig,1) = QuadriMesh.edge2elem(ig,2);
QuadriMesh.edge2elem(ig,2) = 0;

%% Secondary mesh info: element vs its 4 edges 
% LblVrtx = zeros(1,3);
QuadriMesh.elem2edge = zeros(NumEms,4);
for ie=1:NumEms
  LblVrtx = QuadriMesh.elem(ie,1:4);
  QuadriMesh.elem2edge(ie,1) = NodeEdge(LblVrtx(1),LblVrtx(2));
  QuadriMesh.elem2edge(ie,2) = NodeEdge(LblVrtx(2),LblVrtx(3));
  QuadriMesh.elem2edge(ie,3) = NodeEdge(LblVrtx(3),LblVrtx(4));
  QuadriMesh.elem2edge(ie,4) = NodeEdge(LblVrtx(4),LblVrtx(1));
end

return;