// vector.h
//
// A class for double vectors
//
// Jiangguo (James) Liu, ColoState, 01/2007--10/2011 
// With the great help of Rachel Cali (Spring 2007)


#ifndef VECTOR_H
#define VECTOR_H

#include <iostream>

class Vector {
public: 
  Vector(int numElts, double a=0);  // Constructor, all elements a or 0
  Vector(int numElts, double *data);  // Constructor with given data
  Vector(const Vector &v);  // Copy constructor, very useful
  Vector &operator=(const Vector &v);  // Copy assignment
    // The copy constructor looks silly willy but is ABSOLUTELY necessary
    // It is implicitly used by functions returnig a vector
    // Meanwhile the destructor is also implicitly called by those functions
  ~Vector() {delete[] p; p=0; n=0;}  // Destructor
  void resize(int numElts);  // Resize the vector
  double &operator[](int i) const {return p[i];}  // 0<=i<n
  double &operator()(int i) const {return p[i-1];}  // 1<=i<=n
  int size() const {return n;}
  double l0norm() const;  // l_infty norm
  double l1norm() const;  // l_1 norm
  double l2norm() const;  // l_2 norm
  Vector get(int i, int length);  // get subvector
  Vector replace(int i, const Vector &v);  // replace subvector
  Vector &operator+=(const Vector&);  // v += w
  Vector &operator-=(const Vector&);  // v -= w
  Vector operator-() const;  // Unary -
  void save2file(char fn[20]) const;  // save to a data file
friend Vector operator+(const Vector&, const Vector&);  // v = v1 + v2;
friend Vector operator-(const Vector&, const Vector&);  // v = v1 + v2;
// friend Vector operator*(const Vector&, const Vector&);
// v = v1*v2, componentwise
// friend Vector operator/(const Vector&, const Vector&);
// v = v1/v2, componentwise
friend Vector operator*(const double, const Vector&);  // Scalar-vector multiplication
friend double operator*(const Vector&, const Vector&);  // Dot product
friend double dotProd(const Vector&, const Vector&);  // Dot product
friend std::ostream &operator<<(std::ostream&strm, const Vector&v);
private: 
   int n;
   double *p;
};

#endif  // VECTOR_H
