// subs.cpp
//
// Some subroutines for 
// for the 2nd order finite volume method on quadrilateral meshes 
// for parabolic problems with homogeneous Dirichlet boundary conditions
//
// Jiangguo (James) Liu, ColoState, 01/2008--10/2011 


#include "matrix.h"
#include "Quadri2Mesh.h"
#include "vector.h"


// Adjust the linear system 
// according to the homogenuous Dirichlet boundary condition

void adjstLinSysBCs(SparseMatrix &glbCoeffMat, Vector &glbRHS, 
   const Quadri2Mesh &mesh) 
{
   int i, j, label;

   j =0;
   for (i=0; i<=mesh.getNumPcsX(); ++i) {
      label = mesh.getLblNd(i, j, 1);
      glbCoeffMat.zeroutRow(label);
      glbCoeffMat.setEntry(label, label, 1.0);
      glbRHS(label) = 0.0;
   }

   j = mesh.getNumPcsY();
   for (i=0; i<=mesh.getNumPcsX(); ++i) {
      label = mesh.getLblNd(i, j, 1);
      glbCoeffMat.zeroutRow(label);
      glbCoeffMat.setEntry(label, label, 1.0);
      glbRHS(label) = 0.0;
   }

   i = 0;
   for (j=1; j<mesh.getNumPcsY(); ++j) {
      label = mesh.getLblNd(i, j, 1);
      glbCoeffMat.zeroutRow(label);
      glbCoeffMat.setEntry(label, label, 1.0);
      glbRHS(label) = 0.0;
   }

   i = mesh.getNumPcsX();
   for (j=1; j<mesh.getNumPcsY(); ++j) {
      label = mesh.getLblNd(i, j, 1);
      glbCoeffMat.zeroutRow(label);
      glbCoeffMat.setEntry(label, label, 1.0);
      glbRHS(label) = 0.0;
   }

   j = 0;
   for (i=1; i<=mesh.getNumPcsX(); ++i) {
      label = mesh.getLblNd(i, j, 2);
      glbCoeffMat.zeroutRow(label);
      glbCoeffMat.setEntry(label, label, 1.0);
      glbRHS(label) = 0.0;
   }

   j = mesh.getNumPcsY();
   for (i=1; i<=mesh.getNumPcsX(); ++i) {
      label = mesh.getLblNd(i, j, 2);
      glbCoeffMat.zeroutRow(label);
      glbCoeffMat.setEntry(label, label, 1.0);
      glbRHS(label) = 0.0;
   }

   i = 0;
   for (j=1; j<=mesh.getNumPcsY(); ++j) {
      label = mesh.getLblNd(i, j, 3);
      glbCoeffMat.zeroutRow(label);
      glbCoeffMat.setEntry(label, label, 1.0);
      glbRHS(label) = 0.0;
   }

   i = mesh.getNumPcsX();
   for (j=1; j<=mesh.getNumPcsY(); ++j) {
      label = mesh.getLblNd(i, j, 3);
      glbCoeffMat.zeroutRow(label);
      glbCoeffMat.setEntry(label, label, 1.0);
      glbRHS(label) = 0.0;
   }

   return;
}
