// main.cpp
//
// The main program 
// for the 2nd order finite volume method on quadrilateral meshes 
// for parabolic problems with homogeneous Dirichlet boundary conditions
//
// Jiangguo (James) Liu, ColoState, 01/2008--10/2011

#include <cmath>
#include <iostream>
#include "Ex2Fxns.h"
#include "LinSys.h"
#include "matrix.h"
#include "Quadri2Mesh.h"
#include "subs.h"
#include "vector.h"
using namespace std;

void main() 
{
  int m, n, MT, NT;
  int maxItr=2000, printit=0;
  double Deltat, deltat, T, tnew;
  double atol=1E-24, res=0.0;

  T = 0.2;
  NT = 128;
  Deltat = T/NT;
  MT = 1;
  deltat = Deltat/MT;

  Quadri2Mesh mesh("Ex2QuadriMesh64.dat");
  Vector glbRHS(mesh.getNumNds());
  Vector Unew(mesh.getNumNds());
  Vector Uold(mesh.getNumNds());
  Vector Uolder(mesh.getNumNds());
  Vector Uoldest(mesh.getNumNds());
  Vector Fnew(mesh.getNumNds());
  Vector Fold(mesh.getNumNds());
  Vector uT(mesh.getNumNds());
  Vector err(mesh.getNumNds());
  Vector allerr(NT);

  SparseMatrix glbMassMat, glbStfMat, glbCoeffMat;
  DiagMatrix diagPreCond, glbMeowMat;

  cout << "Assembling the global mass and stiffness matrices...";
  mesh.setGlbMats(glbMassMat, glbStfMat);
  mesh.asmGlbMassMat(glbMassMat);
  mesh.asmGlbStfMat(glbStfMat, ex2a);
  cout << "done!\n";

  // For n=1, applying BDF1 (= backward Euler) 
  n = 1;
  cout << "n=" << n << "  ";
  glbCoeffMat = glbMassMat + Deltat*glbStfMat;
  diagPreCond = diagonal(glbCoeffMat);
  Uold = mesh.evalFxnAllNds(ex2u, 0.0);
  tnew = Deltat;
  Fnew = mesh.evalFxnAllNds(ex2f, tnew);
  glbRHS = glbMassMat*(Uold + Deltat*Fnew);
  adjstLinSysBCs(glbCoeffMat, glbRHS, mesh);
  slvSpaLinSysBiCGStab(Unew, glbCoeffMat, glbRHS, diagPreCond, 
    maxItr, res, atol, printit);
  uT = mesh.evalFxnAllNds(ex2u, tnew);
  err = uT - Unew;
  // cout << "err_max= " << err.l0norm() << "  ";
  // cout << "err_0= " << mesh.cmptNorm0(glbMassMat, err) << "  ";
  // cout << "err_{1,h}= " << mesh.cmptNorm1h(err) << "  ";
  // cout << "\n";
  cout << "errL2= " << mesh.cmptL2NormErrAprxSln(ex2u, tnew, Unew) << "  ";
  cout << "errH1= " << mesh.cmptH1SemiNormErrAprxSln(ex2ux, ex2uy, tnew, Unew) << "  ";
  cout << "\n";
  allerr(n) = mesh.cmptL2NormErrAprxSln(ex2u, tnew, Unew);
  // allerr(n) = mesh.cmptH1SemiNormErrAprxSln(ex2ux, ex2uy, tnew, Unew);

  // For n=2, applying BDF2 
  n = 2;
  cout << "n=" << n << "  ";
  glbCoeffMat = 1.5*glbMassMat + Deltat*glbStfMat;
  diagPreCond = diagonal(glbCoeffMat);
  Uolder = Uold;  Uold = Unew;
  tnew = n*Deltat;
  Fnew = mesh.evalFxnAllNds(ex2f, tnew);
  glbRHS = glbMassMat*(2.0*Uold - 0.5*Uolder + Deltat*Fnew);
  adjstLinSysBCs(glbCoeffMat, glbRHS, mesh);
  slvSpaLinSysBiCGStab(Unew, glbCoeffMat, glbRHS, diagPreCond, 
    maxItr, res, atol, printit);
  uT = mesh.evalFxnAllNds(ex2u, tnew);
  err = uT - Unew;
  // cout << "err_max= " << err.l0norm() << "  ";
  // cout << "err_0= " << mesh.cmptNorm0(glbMassMat, err) << "  ";
  // cout << "err_{1,h}= " << mesh.cmptNorm1h(err) << "  ";
  // cout << "\n";
  cout << "errL2= " << mesh.cmptL2NormErrAprxSln(ex2u, tnew, Unew) << "  ";
  cout << "errH1= " << mesh.cmptH1SemiNormErrAprxSln(ex2ux, ex2uy, tnew, Unew) << "  ";
  cout << "\n";
  allerr(n) = mesh.cmptL2NormErrAprxSln(ex2u, tnew, Unew);
  // allerr(n) = mesh.cmptH1SemiNormErrAprxSln(ex2ux, ex2uy, tnew, Unew);

  // For n>=3, applying BDF3 
  glbCoeffMat = (11.0/6)*glbMassMat + Deltat*glbStfMat;
  diagPreCond = diagonal(glbCoeffMat);
  // Uoldest = mesh.evalFxnAllNds(ex2u, 0.0);
  Uoldest = Uolder;  Uolder = Uold;  Uold = Unew;
  for (n=3; n<=NT; ++n) {
    cout << "n=" << n << "  ";
    tnew = n*Deltat;
    Fnew = mesh.evalFxnAllNds(ex2f, tnew);
    glbRHS = glbMassMat*(3.0*Uold - 1.5*Uolder + (1.0/3)*Uoldest + Deltat*Fnew);
    adjstLinSysBCs(glbCoeffMat, glbRHS, mesh);
    slvSpaLinSysBiCGStab(Unew, glbCoeffMat, glbRHS, diagPreCond, 
      maxItr, res, atol, printit);
    uT = mesh.evalFxnAllNds(ex2u, tnew);
    err = uT - Unew;
    // cout << "err_max= " << err.l0norm() << "  ";
    // cout << "err_0= " << mesh.cmptNorm0(glbMassMat, err) << "  ";
    // cout << "err_{1,h}= " << mesh.cmptNorm1h(err) << "  ";
	// cout << "\n";
    cout << "errL2= " << mesh.cmptL2NormErrAprxSln(ex2u, tnew, Unew) << "  ";
    cout << "errH1= " << mesh.cmptH1SemiNormErrAprxSln(ex2ux, ex2uy, tnew, Unew) << "  ";
	cout << "\n";
    allerr(n) = mesh.cmptL2NormErrAprxSln(ex2u, tnew, Unew);
    // allerr(n) = mesh.cmptH1SemiNormErrAprxSln(ex2ux, ex2uy, tnew, Unew);

	// Preparing for the next step
	Uoldest = Uolder;  Uolder = Uold;  Uold = Unew;
  }
  cout << "\n";

  uT.save2file("uT.dat");
  Unew.save2file("Unew.dat");
  // glbMassMat.save2file("GlbMassMat.dat");
  // glbCoeffMat.save2file("GlbCoeffMat.dat");
  // diagPreCond.save2file("DiagMat.dat");

  cout << "Err in max norm = " << allerr.l0norm() << "\n";
  // cout << "Err in Energy Norm=" << mesh.cmptNorm0(glbMassMat,err)+sqrt(Deltat)*allerr.l2norm() << "\n";

  cout << "Every thing is fine!\n";
  return;
}
