// Quadri2Mesh.h
//
// (2-dim) quadrilateral meshes 
// affine biquadratic finite volme approximation 
//
// Jiangguo (James) Liu, ColoState, 01/2008--10/2011

#ifndef QUADRI2MESH_H
#define QUADRI2MESH_H

#include "matrix.h"
#include "PtVec2d.h"
#include "vector.h"

class Quadri2Mesh {
public:
  Quadri2Mesh() {nx=0; ny=0; nd=0;}
  Quadri2Mesh(char *filename);
  ~Quadri2Mesh() {delete[] nd;}
  int getNumElts() const {return nx*ny;}
  int getNumNds() const {return (2*nx+1)*(2*ny+1);}
  int getNumDualVols() const {return (2*nx+1)*(2*ny+1);}
  int getNumPcsX() const {return nx;}
  int getNumPcsY() const {return ny;}
  int getLblNd(int i, int j, int type) const;
  int getLblDualVol(int i, int j, int type) const;
  FullMatrix cmptEltMassMat(int i, int j) const;
  FullMatrix cmptEltStfMat(int i, int j, double (*perm)(double*)) const;
  void setGlbMats(SparseMatrix &glbMassMat, SparseMatrix &glbStfMat);
  void asmGlbMassMat(SparseMatrix &glbMassMat);
  void asmGlbStfMat(SparseMatrix &glbStfMat, double (*perm)(double*));
  void asmGlbMats0(SparseMatrix &glbMassMat, SparseMatrix &glbStfMat, 
	double (*perm)(double*));
  // void setGlbMats(SparseMatrix &glbMassMat, SparseMatrix &glbStfMat, 
  //  double (*perm)(double*));
  DiagMatrix cmptGlbMeowMat() const;
  Vector evalFxnAllNds(double (*fxn)(double*), double t) const;
  double cmptL2NormErrIntpln(double (*fxn)(double*), double t) const;
  double cmptL2NormErrAprxSln(double (*fxn)(double*), double t, 
	const Vector &U) const;
  double cmptH1SemiNormErrAprxSln(double (*fxnux)(double*), 
	double (*fxnuy)(double*), double t, const Vector &U) const;
  double cmptNorm0(const SparseMatrix glbMassMat, const Vector &U) const;
  double cmptNorm0h(const DiagMatrix glbMeowMat, const Vector &U) const;
  double cmptNorm1h(const Vector &U) const;
private: 
  int nx, ny, n1, n2, n3, n4;
  PtVec2d *nd;
};

#endif  // QUADRI2MESH_H

/*
Assumptions: 
1.The quadrilateral mesh is equivalent to (logically) a rectangular mesh
    nx elements in the x-direction 
    ny elements in the y-direction 
2.The nodes are arranged from left to right, from bottom to top
    the inner loop i: 0->nx  
    the outer loop j: 0->ny
*/
