// PtVec2d.h
//
// A class for points or vectors in 2-dim
//
// Jiangguo (James) Liu, ColoState, 01/2007--10/2011 
// With the great help of Rachel Cali (Spring 2007)


#ifndef PTVEC2d_H
#define PTVEC2d_H

#include <iostream>

class PtVec2d {
public:
   PtVec2d(double a=0, double b=0) {x=a; y=b;}  // Default constructor
   PtVec2d(const PtVec2d &P) {x=P.x; y=P.y;}  // Copy constructor
   PtVec2d &operator=(const PtVec2d&);  // Copy assignment
   double xCrd() const {return x;}
   double yCrd() const {return y;}
   double l0norm() const;
   double l2norm() const;
friend double dist(const PtVec2d&, const PtVec2d&);
friend PtVec2d operator+(const PtVec2d&, const PtVec2d&);
friend PtVec2d operator-(const PtVec2d&, const PtVec2d&);
friend PtVec2d operator*(double, const PtVec2d&);
friend double dotProd(const PtVec2d&, const PtVec2d&);
friend bool operator<=(const PtVec2d&, const PtVec2d&);
friend std::ostream &operator<<(std::ostream&strm, const PtVec2d&);
private:
   double x, y;
};

#endif  // PTVEC2d_H
