// PtVec2d.cpp
//
// Jiangguo (James) Liu, ColoState, 01/2007--10/2011
// With the great help of Rachel Cali (Spring 2007)


#include <cmath>
#include <iostream>
#include "PtVec2d.h"


// PtVec2d: copy assignment 

PtVec2d &PtVec2d::operator=(const PtVec2d &P) 
{
   if (this != &P) {
      x = P.x;
      y = P.y;
   }
   return *this;
}


double PtVec2d::l0norm() const
{
   if (fabs(x)>=fabs(y)) {
      return fabs(x);
   } else {
      return fabs(y);
   }
}


double PtVec2d::l2norm() const 
{
   return sqrt(x*x+y*y);
}


double dist(const PtVec2d &P1, const PtVec2d &P2) 
{
   return sqrt((P1.x-P2.x)*(P1.x-P2.x)+(P1.y-P2.y)*(P1.y-P2.y));
}


PtVec2d operator+(const PtVec2d &V1, const PtVec2d &V2) 
{
   return PtVec2d(V1.x+V2.x, V1.y+V2.y);
}


PtVec2d operator-(const PtVec2d &V1, const PtVec2d &V2) 
{
   return PtVec2d(V1.x-V2.x, V1.y-V2.y);
}


PtVec2d operator*(double a, const PtVec2d &V) 
{
   return PtVec2d(a*V.x, a*V.y);
}


double dotProd(const PtVec2d &V1, const PtVec2d &V2) 
{
   return (V1.x*V2.x + V1.y*V2.y);
}


bool operator<=(const PtVec2d &P1, const PtVec2d &P2) 
{
   bool b = false;
   if (P1.x<=P2.x && P1.y<=P2.y)  b = true;
   return b;
}


// PtVec2d: output stream

std::ostream &operator<<(std::ostream &strm, const PtVec2d &P) 
{
   std::cout << "(x,y)= " << P.x << ", " << P.y << "\n"; 
   return strm;
}
