// LinSys.h
//
// Solvers for full and sparse linear systems
//
// Jiangguo (James) Liu, ColoState, 01/2007--10/2011 
// With the great help of Rachel Cali (Spring 2007)


#ifndef LINSYS_H
#define LINSYS_H

#include "matrix.h"
#include "vector.h"

Vector slvFullLinSysGEPP(const FullMatrix &A, const Vector &b);

Vector slvFullLowerTrigSys(const FullMatrix &L, const Vector &b);

Vector slvFullUpperTrigSys(const FullMatrix &U, const Vector &b);

Vector slvFullSpdSysCholesky(const FullMatrix &A, const Vector &b);

void slvFullSpdSysCG(Vector &x, const FullMatrix &A, const Vector &b, 
   int &itr, int maxItr, double threshold, double tol);

Vector slvDiagSys(const DiagMatrix &A, const Vector &b);

int slvSpaLinSysBiCGStab(Vector &x, const SparseMatrix &A, 
   const Vector &b, const DiagMatrix &B, 
   int &max_iter, double &tol, double atol, int printit);

void slvSpaSpdSysCG(Vector &x, 
   const SparseMatrix &A, const Vector &b, 
   int &itr, int maxItr, double threshold, double tol);

void slvSpaBlkSpdSysCG(Vector &x, 
   const SparseBlockMatrix &A, const Vector &b, 
   int &itr, int maxItr, double threshold, double tol);

void slvBlkDiagSpdSysCholesky(Vector &x, 
   const BlockDiagMatrix &A, const Vector &b);

void slvSpaBlkSpdSysPCG(Vector &x, const SparseBlockMatrix &A, 
   const Vector &b, const BlockDiagMatrix &B, 
   int &itr, int maxItr, double threshold, double tol);

#endif  //  LINSYS_H
