// GaussQuad.h
//
// Gaussian quadratures
//
// Jiangguo (James) Liu, ColoState, 01/2007--10/2011 
// Thanks for the great help of Rachel Cali, Rachelle Barr, 01/2007--05/2007 

#ifndef GAUSSQUAD_H 
#define GAUSSQUAD_H

////////////////////////////////////////

static int GQL1npts = 1;
static double GQL1wab[1][2] = {
  1.00000000000000,  0.00000000000000};

static int GQL2npts = 2;
static double GQL2wab[2][2] = {
  0.50000000000000, -0.57735026918963, 
  0.50000000000000,  0.57735026918963};

static int GQL3npts = 3;
static double GQL3wab[3][2] = {
  0.27777777777778, -0.77459666924148, 
  0.44444444444444,  0.00000000000000, 
  0.27777777777778,  0.77459666924148};

static int GQL4npts = 4;
static double GQL4wab[4][2] = {
  0.17392742255000, -0.8611363116, 
  0.32607257745000, -0.3399810436, 
  0.32607257745000,  0.3399810436, 
  0.17392742255000,  0.8611363116};

static int GQL5npts = 5;
static double GQL5wab[5][2] = {
  0.11846344250000, -0.9061798459, 
  0.23931433525000, -0.5384693101, 
  0.28444444445000,  0.0000000000, 
  0.23931433525000,  0.5384693101,
  0.11846344250000,  0.9061798459};

static int GQL6npts = 6;
static double GQL6wab[6][2] = {
  0.08566224620000, -0.9324695142, 
  0.18038078650000, -0.6612093865, 
  0.23395696730000, -0.2386191861, 
  0.23395696730000,  0.2386191861, 
  0.18038078650000,  0.6612093865, 
  0.08566224620000,  0.9324695142};

static int GQL9npts = 9;
static double GQL9wab[9][2] = {
  0.04063719418080, -0.968160239508, 
  0.09032408034750, -0.836031107327, 
  0.13030534820150, -0.613371432701, 
  0.15617353852000, -0.324253423404, 
  0.16511967750050,  0.000000000000, 
  0.15617353852000,  0.324253423404, 
  0.13030534820150,  0.613371432701, 
  0.09032408034750,  0.836031107327, 
  0.04063719418080,  0.968160239508};

///////////////////////////////////////////////////////////

static int GQR1npts = 1;
static double GQR1wab[1][3] = {
  1.00000000000000,  0.00000000000000,  0.00000000000000};

static int GQR2npts = 4;
static double GQR2wab[4][3] = {
  0.25000000000000, -0.57735026918963, -0.57735026918963,
  0.25000000000000,  0.57735026918963, -0.57735026918963,
  0.25000000000000, -0.57735026918963,  0.57735026918963,
  0.25000000000000,  0.57735026918963,  0.57735026918963};

static int GQR3npts = 9;
static double GQR3wab[9][3] = {
  0.07716049382716, -0.77459666924148, -0.77459666924148,
  0.12345679012346,  0.00000000000000, -0.77459666924148,
  0.07716049382716,  0.77459666924148, -0.77459666924148,
  0.12345679012346, -0.77459666924148,  0.00000000000000,
  0.19753086419753,  0.00000000000000,  0.00000000000000,
  0.12345679012346,  0.77459666924148,  0.00000000000000,
  0.07716049382716, -0.77459666924148,  0.77459666924148,
  0.12345679012346,  0.00000000000000,  0.77459666924148,
  0.07716049382716,  0.77459666924148,  0.77459666924148};

static int GQR4npts = 16;
static double GQR4wab[16][3] = {
  0.03025074831489, -0.86113631160000, -0.86113631160000,
  0.05671296296011, -0.33998104360000, -0.86113631160000,
  0.05671296296011,  0.33998104360000, -0.86113631160000,
  0.03025074831489,  0.86113631160000, -0.86113631160000,
  0.05671296296011, -0.86113631160000, -0.33998104360000,
  0.10632332576489, -0.33998104360000, -0.33998104360000,
  0.10632332576489,  0.33998104360000, -0.33998104360000,
  0.05671296296011,  0.86113631160000, -0.33998104360000,
  0.05671296296011, -0.86113631160000,  0.33998104360000,
  0.10632332576489, -0.33998104360000,  0.33998104360000,
  0.10632332576489,  0.33998104360000,  0.33998104360000,
  0.05671296296011,  0.86113631160000,  0.33998104360000,
  0.03025074831489, -0.86113631160000,  0.86113631160000,
  0.05671296296011, -0.33998104360000,  0.86113631160000,
  0.05671296296011,  0.33998104360000,  0.86113631160000,
  0.03025074831489,  0.86113631160000,  0.86113631160000};

static int GQR5npts = 25;
static double GQR5wab[25][3] = {
  0.01403358720895, -0.90617984590000, -0.90617984590000,
  0.02834999999331, -0.53846931010000, -0.90617984590000,
  0.03369626808955,  0.00000000000000, -0.90617984590000,
  0.02834999999331,  0.53846931010000, -0.90617984590000,
  0.01403358720895,  0.90617984590000, -0.90617984590000,
  0.02834999999331, -0.90617984590000, -0.53846931010000,
  0.05727135105615, -0.53846931010000, -0.53846931010000,
  0.06807163313911,  0.00000000000000, -0.53846931010000,
  0.05727135105615,  0.53846931010000, -0.53846931010000,
  0.02834999999331,  0.90617984590000, -0.53846931010000,
  0.03369626808955, -0.90617984590000,  0.00000000000000,
  0.06807163313911, -0.53846931010000,  0.00000000000000,
  0.08090864197847,  0.00000000000000,  0.00000000000000,
  0.06807163313911,  0.53846931010000,  0.00000000000000,
  0.03369626808955,  0.90617984590000,  0.00000000000000,
  0.02834999999331, -0.90617984590000,  0.53846931010000,
  0.05727135105615, -0.53846931010000,  0.53846931010000,
  0.06807163313911,  0.00000000000000,  0.53846931010000,
  0.05727135105615,  0.53846931010000,  0.53846931010000,
  0.02834999999331,  0.90617984590000,  0.53846931010000,
  0.01403358720895, -0.90617984590000,  0.90617984590000,
  0.02834999999331, -0.53846931010000,  0.90617984590000,
  0.03369626808955,  0.00000000000000,  0.90617984590000,
  0.02834999999331,  0.53846931010000,  0.90617984590000,
  0.01403358720895,  0.90617984590000,  0.90617984590000};

/////////////////////////////////////////////////////////

static int GQT1npts = 1;
static double GQT1wab[1][3] = { 
  1.00000000000000, 0.33333333333333, 0.33333333333333};

static int GQT2npts = 3;
static double GQT2wab[3][3] = { 
  0.33333333333333, 0.66666666666667, 0.16666666666667, 
  0.33333333333333, 0.16666666666667, 0.66666666666667, 
  0.33333333333333, 0.16666666666667, 0.16666666666667};

static int GQT3npts = 4;
static double GQT3wab[4][3] = { 
 -0.56250000000000, 0.33333333333333, 0.33333333333333, 
  0.52083333333333, 0.60000000000000, 0.20000000000000,
  0.52083333333333, 0.20000000000000, 0.60000000000000, 
  0.52083333333333, 0.20000000000000, 0.20000000000000};

static int GQT4npts = 6;
static double GQT4wab[6][3] = { 
  0.10995174365532, 0.8168476, 0.0915762, 
  0.10995174365532, 0.0915762, 0.8168476, 
  0.10995174365532, 0.0915762, 0.0915762, 
  0.22338158967801, 0.1081030, 0.4459485, 
  0.22338158967801, 0.4459485, 0.1081030, 
  0.22338158967801, 0.4459485, 0.4459485};

static int GQT5npts = 7;
static double GQT5wab[7][3] = {
  0.22500000000000, 0.33333333333333, 0.33333333333333,
  0.12593918054482, 0.79742698535308, 0.10128650732345,
  0.12593918054482, 0.10128650732345, 0.79742698535308,
  0.12593918054482, 0.10128650732345, 0.10128650732345,
  0.13239415278850, 0.47014206410511, 0.47014206410511, 
  0.13239415278850, 0.47014206410511, 0.05971587178977,
  0.13239415278850, 0.05971587178977, 0.47014206410511};

static int GQT6npts = 12;
static double GQT6wab[12][3] = { 
  0.11678627572637, 0.5014265, 0.2492867, 
  0.11678627572637, 0.2492867, 0.5014265, 
  0.11678627572637, 0.2492867, 0.2492867, 
  0.05084490637020, 0.8738220, 0.0630890, 
  0.05084490637020, 0.0630890, 0.8738220, 
  0.05084490637020, 0.0630890, 0.0630890, 
  0.08285107561837, 0.6365025, 0.0531450, 
  0.08285107561837, 0.6365025, 0.3103525, 
  0.08285107561837, 0.0531450, 0.6365025, 
  0.08285107561837, 0.0531450, 0.3103525, 
  0.08285107561837, 0.3103525, 0.6365025, 
  0.08285107561837, 0.3103525, 0.0531450};

///////////////////////////////////////////////////////////////////

static int GQTe1npts = 1;
static double GQTe1wab[1][4] = {
  1.000000000000, 0.250000000000, 0.250000000000, 0.250000000000};

static int GQTe2npts = 4;
static double GQTe2wab[4][4] = {
  0.250000000000, 0.585410196624, 0.138196601125, 0.138196601125,
  0.250000000000, 0.138196601125, 0.585410196624, 0.138196601125,
  0.250000000000, 0.138196601125, 0.138196601125, 0.585410196624,
  0.250000000000, 0.138196601125, 0.138196601125, 0.138196601125};

static int GQTe3npts = 5;
static double GQTe3wab[5][4] = {
 -0.800000000000, 0.250000000000, 0.250000000000, 0.250000000000,
  0.450000000000, 0.500000000000, 0.166666666666, 0.166666666666,
  0.450000000000, 0.166666666666, 0.500000000000, 0.166666666666,
  0.450000000000, 0.166666666666, 0.166666666666, 0.500000000000,
  0.450000000000, 0.166666666666, 0.166666666666, 0.166666666666};

static int GQTe4npts = 11;
static double GQTe4wab[11][4] = {
 -0.078933333333, 0.250000000000, 0.250000000000, 0.250000000000,
  0.045733333333, 0.785714285714, 0.071428571428, 0.071428571428,
  0.045733333333, 0.071428571428, 0.785714285714, 0.071428571428,
  0.045733333333, 0.071428571428, 0.071428571428, 0.785714285714,
  0.045733333333, 0.071428571428, 0.071428571428, 0.071428571428,
  0.149333333333, 0.399403576166, 0.100596423833, 0.100596423833,
  0.149333333333, 0.100596423833, 0.399403576166, 0.100596423833,
  0.149333333333, 0.100596423833, 0.100596423833, 0.399403576166, 
  0.149333333333, 0.399403576166, 0.399403576166, 0.100596423833,
  0.149333333333, 0.399403576166, 0.100596423833, 0.399403576166,
  0.149333333333, 0.100596423833, 0.399403576166, 0.399403576166};

#endif  // GAUSSQUAD_H
