%% run_SteadyCD_WG_RectQ0Q0RT0.m
% James Liu, ColoState; 2012/07--2017/02 

% clc;  
clear all;  close all;
format compact;  format long e;

%% Setting up the problem 
xa = 0;  xb = 1;  yc = 0;  yd = 1;
BndryDescMat = [xa,yc,xb,yc, 0,-1;...
                xb,yc,xb,yd, 1, 0;... 
                xb,yd,xa,yd, 0, 1;...
                xa,yd,xa,yc,-1, 0];
% EqnBC = EqnBC_SteadyCD_Ex10sinsin;
% EqnBC = EqnBC_SteadyCD_Ex11ConstVelBndryLayer;
EqnBC = EqnBC_SteadyCD_Ex13Gauss;
% EqnBC = EqnBC_SteadyCD_Ex21ConstVelBndryLayers;
% EqnBC = EqnBC_SteadyCD_Ex22ConstVelBndryIntrLayers;
% EqnBC = EqnBC_SteadyCD_Ex23RotVelBndryLayer;
% EqnBC = EqnBC_SteadyCD_Ex24RotVelBndryIntrLayers;
% EqnBC = EqnBC_SteadyCD_BookOUP2005ElmanSilverWathen_Ex312;
BndryCondType = [0;1;1;1;1];

%% Discretization: Mesh generation and preparation 
% disp('Generating & preparing a uniform rectangular mesh...');
n = 2^5
nx = n;  ny = n;
RectMesh = RectDom_RectMesh_GenUnfm(xa,xb,nx,yc,yd,ny,2);
RectMesh = RectMesh_Enrich1(RectMesh);
RectMesh = RectMesh_Enrich2(RectMesh,BndryDescMat);
RectMesh = RectMesh_Enrich3(RectMesh,BndryDescMat);

%% Setting up quadratures 
GAUSSQUAD = SetGaussQuad(5,25,13);

%% Sorting out boundary edges: Dirichlet, Neumann 
DirichletEdge = find(BndryCondType(RectMesh.BndryEdge+1)==1);
NeumannEdge   = find(BndryCondType(RectMesh.BndryEdge+1)==2);

%% Assembling and Solving using WG(Q0,Q0;RT[0]) 
% disp('WG(Q0,Q0;RT[0]): Assembling and Solving...');
tic;
sln = SteadyCD_WG_RectQ0Q0RT0_AsmSlv(...
  EqnBC,RectMesh,DirichletEdge,NeumannEdge,GAUSSQUAD);
toc

%% "Computing" many things
NumerCntrn = sln(1:RectMesh.NumEms);

%% Presenting numerical & graphical results
[min(NumerCntrn),max(NumerCntrn)]
show_RectMesh_ScaEm_ClrImg(RectMesh, NumerCntrn, ...
  21, 'WG: Numerical concentration');
% show_RectMesh_ScaEm_patch(RectMesh, NumerCntrn, ...
%   22, 'Numerical concentration');

return;