%% run_Parab_CN_WG_RectQ0P0RT0.m 
% Parabolic equation: Crank-Nicolson, Weak Galerkin (Q0,Q0;RT[0]) 
% James Liu, ColoState; 2012/07--2017/02

% clc;  
clear all;  close all;
format compact;  format long e;

%% Setting up the problem 
xa = 0;  xb = 1;  yc = 0;  yd = 1;
BndryDescMat = [xa,yc,xb,yc, 0,-1;...
                xb,yc,xb,yd, 1, 0;... 
                xb,yd,xa,yd, 0, 1;...
                xa,yd,xa,yc,-1, 0];
% "0" for convenience 
EqnBIC = EqnBIC_Parab_Ex11eatsinsin;
BndryCondType = [0;1;1;1;1];

%% Discretization: Mesh generation and preparation 
% disp('Generating & preparing a uniform rectangular mesh ...');
n = 16 
nx = n;  ny = n;
RectMesh = RectDom_RectMesh_GenUnfm(xa,xb,nx,yc,yd,ny,2);
RectMesh = RectMesh_Enrich1(RectMesh);
RectMesh = RectMesh_Enrich2(RectMesh,BndryDescMat);
RectMesh = RectMesh_Enrich3(RectMesh,BndryDescMat);

%% Setting up Gaussian quadratures 
GAUSSQUAD = SetGaussQuad(5,25,13);

%% Sorting out boundary edges: Dirichlet, Neumann 
DirichletEdge = find(BndryCondType(RectMesh.BndryEdge+1)==1);
NeumannEdge   = find(BndryCondType(RectMesh.BndryEdge+1)==2);

%% Timing 
T = EqnBIC.T;  
NT = n;  MT = NT;  Deltat = T/NT;  tm = (0:NT)*Deltat;
tyme.T = T;  tyme.NT = NT;  tyme.MT = MT; 
tyme.Deltat = Deltat;  tyme.tm = tm;

%% Assembling and solving 
disp('Crank-Nicolson + WG(Q0,Q0;RT[0]) solving ...');
sln = Parab_CN_WG_RectQ0Q0RT0_AsmSlv(...
  EqnBIC,RectMesh,tyme,DirichletEdge,NeumannEdge,GAUSSQUAD);

%% Retrieving 
NumerCntrnT = sln(1:RectMesh.NumEms,MT+1);

%% Projecting the initial concentration 
ProjCntrn0 = WG_RectQ0Q0RT0_ProjScaFxn0(RectMesh,GAUSSQUAD,EqnBIC.fxnc0);

%% Projecting the exact concentration at final time (assuming known) 
ProjCntrnT = WG_RectQ0Q0RT0_ProjScaFxn1(...
  RectMesh,GAUSSQUAD,EqnBIC.fxnc,T*(MT/NT));

%% Presenting numerical and graphical results 
[min(ProjCntrnT.em), max(ProjCntrnT.em)]
[min(NumerCntrnT), max(NumerCntrnT)]
max(ProjCntrnT.em)-max(NumerCntrnT)
% show_RectMesh_ScaEm_ClrImg(RectMesh, ProjCntrn0.em, ...
%   11, 'Projected initial concentration');
show_RectMesh_ScaEm_ClrImg(RectMesh, ProjCntrnT.em, ...
  12, 'Projected concentration');
show_RectMesh_ScaEm_ClrImg(RectMesh, NumerCntrnT, ...
  21, 'Numerical concentration');

return;