%% run_Parab_CN_CG_RectQ1.m 
% Parabolic eqn: Crank-Nicolson + Continuous Galerkin Q1 on a rectangular mesh  
% James Liu, ColoState; 2012/07--2017/02 

% clc;  
clear all;  close all;
format compact;  format long e;

%% Setting up the problem 
xa = 0;  xb = 1;  yc = 0;  yd = 1;
BndryDescMat = [xa,yc,xb,yc, 0,-1;...
                xb,yc,xb,yd, 1, 0;... 
                xb,yd,xa,yd, 0, 1;...
                xa,yd,xa,yc,-1, 0];
% "0" for convenience 
EqnBIC = EqnBIC_Parab_Ex11eatsinsin;
BndryCondType = [0;1;1;1;1];

%% Discretization: Mesh generation and preparation 
% disp('Generating & preparing a uniform rectangular mesh ...');
n = 16 
nx = n;  ny = n;
RectMesh = RectDom_RectMesh_GenUnfm(xa,xb,nx,yc,yd,ny,2);
RectMesh = RectMesh_Enrich1(RectMesh);
RectMesh = RectMesh_Enrich2(RectMesh,BndryDescMat);
RectMesh = RectMesh_Enrich3(RectMesh,BndryDescMat);

%% Setting up Gaussian quadratures 
GAUSSQUAD = SetGaussQuad(5,25,13);

%% Sorting out boundary edges: Dirichlet, Neumann 
DirichletEdge = find(BndryCondType(RectMesh.BndryEdge+1)==1);
NeumannEdge   = find(BndryCondType(RectMesh.BndryEdge+1)==2);

%% Timing 
T = EqnBIC.T;  
NT = n;  MT = NT;  Deltat = T/NT;  tm = (0:NT)*Deltat;
tyme.T = T;  tyme.NT = NT;  tyme.MT = MT; 
tyme.Deltat = Deltat;  tyme.tm = tm;

%% Assembling and solving 
disp('Solving parabolic BIVP: CN + CG(RectQ1)...');
sln = Parab_CN_CG_RectQ1_AsmSlv(...
  EqnBIC,RectMesh,tyme,DirichletEdge,NeumannEdge,GAUSSQUAD);

%% Retrieving 
NumerCntrnT = sln(1:RectMesh.NumNds,MT+1);

%% Converting 
NumerCntrnT_Q0Em = RectMesh_ConvCQ1toQ0(RectMesh,NumerCntrnT);

%% Presenting numerical and graphical results 
[min(NumerCntrnT), max(NumerCntrnT)]
show_RectMesh_ScaNd_mesh(RectMesh, NumerCntrnT, ...
  21, 'Numerical concentration');
show_RectMesh_ScaEm_ClrImg(RectMesh, NumerCntrnT_Q0Em, ...
  22, 'Numerical concentration');

return;