function CofRT0EgBas = TriMesh_RT0_NmlzBas_EgBas(TriMesh,CofRT0NmlzBas)
%% TriMesh: For local RT0, converting coeffs. in normalized basis to edge basis 
% James Liu, ColoState; 2012/07--2017/02 

%% Mesh info 
NumEms = TriMesh.NumEms;
% NumEgs = TriMesh.NumEgs;
% Vertices and their coordinates 
kind = zeros(NumEms,3);
x = zeros(NumEms,3);
y = zeros(NumEms,3);
for j=1:3
  kind(:,j) = TriMesh.elem(:,j);
  x(:,j) = TriMesh.node(kind(:,j),1);
  y(:,j) = TriMesh.node(kind(:,j),2);
end
area = 0.5 * ( (x(:,2)-x(:,1)) .* (y(:,3)-y(:,1))...
            -  (x(:,3)-x(:,1)) .* (y(:,2)-y(:,1)) );
xc = (1/3) * sum(x,2);
yc = (1/3) * sum(y,2);

%% Elementwise edge length for 3 edges 
LenEg = zeros(NumEms,3);
LenEg(:,1) = sqrt( (x(:,3)-x(:,2)).^2 + (y(:,3)-y(:,2)).^2 );
LenEg(:,2) = sqrt( (x(:,1)-x(:,3)).^2 + (y(:,1)-y(:,3)).^2 );
LenEg(:,3) = sqrt( (x(:,2)-x(:,1)).^2 + (y(:,2)-y(:,1)).^2 );

%%  
CofRT0EgBas = zeros(NumEms,3);
AuxMat = zeros(NumEms,3,3);
for j=1:3
  AuxMat(:,j,1) = (0.5./area) .* LenEg(:,j) .* (xc(:)-x(:,j));
  AuxMat(:,j,2) = (0.5./area) .* LenEg(:,j) .* (yc(:)-y(:,j));
  AuxMat(:,j,3) = LenEg(:,j);
end
for ie=1:NumEms
  MatA = inv( squeeze(AuxMat(ie,:,:)) );
  CofRT0EgBas(ie,:) = CofRT0NmlzBas(ie,:) * MatA;
end

return;