function RT00 = TriMesh_ConvRT0toRT00(TriMesh,CofRT0)
% TriMesh: Converting coeffs. in local RT0 to elementwise constant vectors 
% James Liu, ColoState; 2012/07--2017/02 

%% Mesh info 
NumEms = TriMesh.NumEms;
% Assuming these mesh info items are available: 
area = TriMesh.area;
LenEg = TriMesh.LenEg;
e2g = TriMesh.elem2edge;

%% Auxiliary quantities 
P1 = TriMesh.node(TriMesh.elem(:,1),:);
P2 = TriMesh.node(TriMesh.elem(:,2),:);
P3 = TriMesh.node(TriMesh.elem(:,3),:);
Pc = (1/3)*(P1+P2+P3);

%% Converting 
coeff = zeros(NumEms,3);
for j=1:3
  coeff(:,j) = CofRT0(:,j).*LenEg(e2g(:,j))./(2*area);
end
RT00 = repmat(coeff(:,1),1,2).*(Pc-P1)...
     + repmat(coeff(:,2),1,2).*(Pc-P2)... 
     + repmat(coeff(:,3),1,2).*(Pc-P3);

return;