function P0Em = TriMesh_ConvDP1toP0(TriMesh,CofDP1)
% TriMesh: Converting DP1 (disc.poly.deg1) to P0 (pcws.const.) 
% James Liu, ColoState; 2012/07--2017/02 

%% Mesh info 
% NumEms = TriMesh.NumEms;
k1 = TriMesh.elem(:,1);  k2 = TriMesh.elem(:,2);  k3 = TriMesh.elem(:,3);
x1 = TriMesh.node(k1,1);  y1 = TriMesh.node(k1,2); 
x2 = TriMesh.node(k2,1);  y2 = TriMesh.node(k2,2);
x3 = TriMesh.node(k3,1);  y3 = TriMesh.node(k3,2);
% element centers 
xc = (1/3)*(x1+x2+x3);
yc = (1/3)*(y1+y2+y3);

%% Converting 
% NOTE: CofDP1 has size NumEms-by-3 
% NOTE: P0Em has size NumEms-by-3 
P0Em = CofDP1(:,1) + CofDP1(:,2).*xc + CofDP1(:,3).*yc;

return;