function CofRT0 = TriMesh_ConvBDM1toRT0(TriMesh,CofBDM1)
% TriMesh: Converting coeffs. in local BDM1 to coeffs. in local RT0 
% Cf. Lin,Liu,Sadre, J.Comput.Appl.Math., 2015, p.39, formula(8)
% James Liu, ColoState; 2012/07--2017/02 

%% Mesh info 
NumEms = TriMesh.NumEms;

%% Converting 
% NOTE: CofBDM1 has size NumEms-by-6;
CofRT0 = zeros(NumEms,3);
CofRT0(:,1) = 0.5*(CofBDM1(:,1)+CofBDM1(:,2));
CofRT0(:,2) = 0.5*(CofBDM1(:,3)+CofBDM1(:,4));
CofRT0(:,3) = 0.5*(CofBDM1(:,5)+CofBDM1(:,6));

return;