function GaussQuadTrig = SetGaussQuadTrig(ch3)
%% Setting up a Gaussian quadrature for triangles 
% James Liu, Rachel Cali, Zhuoran Wang, ColoState; 2007/01--2017/02 

%% Format: barycentric coordinates and weights
% For triangles:  alpha1, alpah2, alpah3, weight 

% For now #points = 1,3,4,6,7,9,13
GaussQuadTrig = [];

switch ch3  % choice 3 for triangles 
case 1 
  % 1-point (the center) quad. for triangles, Exact for poly. deg.<=1 
  GaussQuadTrig = zeros(1,4);
  GaussQuadTrig(:,1:3) = [1/3, 1/3, 1/3];
  GaussQuadTrig(:,4) = 1;
case 3 
  % 3-point quadrature for triangles, Exact for poly. deg.<=2 
  GaussQuadTrig = zeros(3,4);
  GaussQuadTrig(:,1:3) = [4,1,1; 1,4,1; 1,1,4]/6;
  GaussQuadTrig(:,4) = [1; 1; 1]/3;
case 4 
  % 4-point quadrature for triangles, Exact for poly. deg.<=3 
  a = 1/3;  b = 9/15;  c = 3/15;
  u = -27/48;  v = 25/48;
  GaussQuadTrig = zeros(4,4);
  GaussQuadTrig(:,1:3) = [a,a,a; b,c,c; c,b,c; c,c,b];
  GaussQuadTrig(:,4) = [u; v;v;v];
case 6 
  % 6-point quadrature for triangles, Exact for poly. deg.<=4 
  a = 0.816847572980459;  b = 0.091576213509771;
  c = 0.108103018168070;  d = 0.445948490915965;
  u = 0.109951743655322;  v = 0.223381589678011;
  GaussQuadTrig = zeros(6,4);
  GaussQuadTrig(:,1:3) = [a,b,b; b,a,b; b,b,a; c,d,d; d,c,d; d,d,c];
  GaussQuadTrig(:,4) = [u;u;u; v;v;v];
case 7
  % 7-point quadrature for triangles, Exact for poly. deg.<=5 
  a = 1/3;  
  b = (9+2*sqrt(15))/21;  % b = 0.797426985353087; 
  c =   (6-sqrt(15))/21;  % c = 0.101286507323456; 
  d =   (6+sqrt(15))/21;  % d = 0.470142064105115; 
  e = (9-2*sqrt(15))/21;  % e = 0.059715871789770;
  u = 0.225;  v = (155-sqrt(15))/1200.0;  w = (155+sqrt(15))/1200;
  GaussQuadTrig = zeros(7,4);
  GaussQuadTrig(:,1:3) = [a,a,a; b,c,c; c,b,c; c,c,b;...
    d,d,e; d,e,d; e,d,d];
  GaussQuadTrig(:,4) = [u; v;v;v; w;w;w];
case 9 
  % 9-point quadrature for triangles, Exact for poly. deg.<=6 
  a = 0.437525248383384;  b = 0.124949503233232;
  c = 0.797112651860071;  d = 0.165409927389841;  e = 0.037477420750088;
  u = 0.205950504760887;  v = 0.063691414286223;
  GaussQuadTrig(:,1:3) = [a,a,b; a,b,a; b,a,a;...
    c,d,e; c,e,d; d,c,e; d,e,c; e,c,d; e,d,c];
  GaussQuadTrig(:,4) = [u;u;u; v;v;v;v;v;v];
case 12 
  % JL20130930: See Riv_BookSIAM_2008, pp.160--161 
  % 12-point quadrature for triangles, Exact for poly. deg.<=6 
  GaussQuadTrig = zeros(12,4);
case 13 
  % 13-point quadrature for triangles, Exact for poly. deg.<=7 
  a = 0.479308067841923;  b = 0.260345966079039;
  c = 0.869739794195568;  d = 0.065130102902216;
  e = 0.638444188569809;  f = 0.312865496004875;  g = 0.048690315425316;
  s =-0.149570044467670;  t = 0.175615257433204;
  u = 0.053347235608839;  v = 0.077113760890257;
  GaussQuadTrig = zeros(13,4);
  GaussQuadTrig(:,1:3) = [1/3,1/3,1/3;...
    a,b,b; b,a,b; b,b,a; c,d,d; d,c,d; d,d,c;...
    e,f,g; e,g,f; f,e,g; f,g,e; g,e,f; g,f,e];
  GaussQuadTrig(:,4) = [s; t;t;t; u;u;u; v;v;v;v;v;v];
otherwise  % default 1-point 
  % disp('Wrong choice, default: 1-point');
  GaussQuadTrig = zeros(1,4);
  GaussQuadTrig(:,1:3) = [1/3, 1/3, 1/3];
  GaussQuadTrig(:,4) = 1;
end

return;