function GaussQuadLine = SetGaussQuadLine(ch1)
%% Setting up a Gaussian quadrature for interval or line segments (edges) 
% James Liu, Rachel Cali, Zhuoran Wang, ColoState; 2007/01--2017/02 

%% Format: barycentric coordinates and weights
% For line segements:  alpha1, alpah2, weight 

% For now #points = 1,2,3,4,5,6,7,8,9,10,15
GaussQuadLine = [];

switch ch1  % choice 1 for line segments 
case 1 
  % 1-point Gaussian quadrature on a line segment (the center)
  GaussQuadLine = [
  0.50000000000000  0.50000000000000  1.00000000000000];
case 2
  % 2-point Gaussian quadrature on a line segment
  GaussQuadLine = [
  0.788675134594813   0.211324865405187   0.500000000000000;
  0.211324865405187   0.788675134594813   0.500000000000000];
case 3
  % 3-point Gaussian quadrature on a line segment 
  GaussQuadLine = [
  0.88729833462074  0.11270166537926  0.27777777777778; 
  0.50000000000000  0.50000000000000  0.44444444444444; 
  0.11270166537926  0.88729833462074  0.27777777777778];
case 4
  % 4-point Gaussian quadratrue on a line segment
  GaussQuadLine = [
  0.930568155797026   0.069431844202974   0.173927422568727;
  0.669990521792428   0.330009478207572   0.326072577431273;
  0.330009478207572   0.669990521792428   0.326072577431273;
  0.069431844202974   0.930568155797026   0.173927422568727];
case 5 
  % 5-point Gaussian quadrature on a line segment 
  GaussQuadLine = [
  0.95308992295000  0.04691007705000  0.11846344250000;
  0.76923465505000  0.23076534495000  0.23931433525000; 
  0.50000000000000  0.50000000000000  0.28444444445000; 
  0.23076534495000  0.76923465505000  0.23931433525000; 
  0.04691007705000  0.95308992295000  0.11846344250000];
case 6 
  % 6-point Gaussian quadrature on a line segment
  GaussQuadLine = [
  0.966234757101576   0.033765242898424   0.085662246189585;
  0.830604693233132   0.169395306766868   0.180380786524069;
  0.619309593041598   0.380690406958402   0.233956967286345;
  0.380690406958402   0.619309593041598   0.233956967286345;
  0.169395306766868   0.830604693233132   0.180380786524069;
  0.033765242898424   0.966234757101576   0.085662246189585];
case 7 
  % 7-point Gaussian quadrature on a line segment
  GaussQuadLine = [
  0.974553956171379   0.025446043828621   0.064742483084435;
  0.870765592799697   0.129234407200303   0.139852695744638;
  0.702922575688699   0.297077424311301   0.190915025252559;
  0.500000000000000   0.500000000000000   0.208979591836735;
  0.297077424311301   0.702922575688699   0.190915025252559;
  0.129234407200303   0.870765592799697   0.139852695744638;
  0.025446043828621   0.974553956171379   0.064742483084435];
case 8 
  % 8-point Gaussian quadrature on a line segment
  GaussQuadLine = [
  0.980144928248768   0.019855071751232   0.050614268145188;
  0.898333238706813   0.101666761293187   0.111190517226687;
  0.762766204958164   0.237233795041836   0.156853322938944;
  0.591717321247825   0.408282678752175   0.181341891689181;
  0.408282678752175   0.591717321247825   0.181341891689181;
  0.237233795041836   0.762766204958164   0.156853322938944;
  0.101666761293187   0.898333238706813   0.111190517226687;
  0.019855071751232   0.980144928248768   0.050614268145188];     
case 9
  % 9-point Gaussian quadrature on a line segment 
  GaussQuadLine = [
  0.98408011975400  0.01591988024600  0.04063719418080; 
  0.91801555366350  0.08198444633650  0.09032408034750; 
  0.80668571635050  0.19331428364950  0.13030534820150; 
  0.66212671170200  0.33787328829800  0.15617353852000; 
  0.50000000000000  0.50000000000000  0.16511967750050; 
  0.33787328829800  0.66212671170200  0.15617353852000; 
  0.19331428364950  0.80668571635050  0.13030534820150; 
  0.08198444633650  0.91801555366350  0.09032408034750; 
  0.01591988024600  0.98408011975400  0.04063719418080];
case 10
  % 10-point Gaussian quadrature on a line segment 
  GaussQuadLine = [
  0.986953264258586   0.013046735741414   0.033335672154344;
  0.932531683344492   0.067468316655508   0.074725674575290;
  0.839704784149512   0.160295215850488   0.109543181257991;
  0.716697697064624   0.283302302935376   0.134633359654998;
  0.574437169490816   0.425562830509184   0.147762112357376;
  0.425562830509184   0.574437169490816   0.147762112357376;
  0.283302302935376   0.716697697064624   0.134633359654998;
  0.160295215850488   0.839704784149512   0.109543181257991;
  0.067468316655508   0.932531683344492   0.074725674575290;
  0.013046735741414   0.986953264258586   0.033335672154344];    
case 15
  % 15-point Gaussian quadrature on a line segment
  GaussQuadLine = [
  0.006003740989757  0.993996259010243  0.030753241996117;
  0.031363303799647  0.968636696200353  0.070366047488108;
  0.075896708294786  0.924103291705214  0.107159220467172;
  0.137791134319915  0.862208865680085  0.139570677926154;
  0.214513913695731  0.785486086304269  0.166269205816994;
  0.302924326461218  0.697075673538782  0.186161000015562;
  0.399402953001283  0.600597046998717  0.198431485327112;
  0.500000000000000  0.500000000000000  0.202578241925561;
  0.600597046998717  0.399402953001283  0.198431485327112;
  0.697075673538782  0.302924326461218  0.186161000015562;
  0.785486086304269  0.214513913695731  0.166269205816994;
  0.862208865680085  0.137791134319915  0.139570677926154;
  0.924103291705214  0.075896708294786  0.107159220467172;
  0.968636696200353  0.031363303799647  0.070366047488108;
  0.993996259010243  0.006003740989757  0.030753241996117];
otherwise
  GaussQuadLine = [];
  disp('Wrong choice!');
end

return;