function GAUSSQUAD = SetGaussQuad(ch1,ch2,ch3)
%% Setting Gaussian quadratures for line segments, rectangles, triangles 
% James Liu, Rachel Cali, Zhuoran Wang, ColoState; 2007/01--2017/02 

%% Format: barycentric coordinates and weights 
% For line segements:  alpha1, alpah2, weight 
% For rectangles:  alpha1x, alpha1y, weight 
% For triangles:  alpha1, alpah2, alpah3, weight 

GAUSSQUAD.LINE = [];  % Now #points=1,2,3,4,5,6,7,8,9,10,15 
GAUSSQUAD.RECT = [];  % Now #points=1,4,9,16,25 
GAUSSQUAD.TRIG = [];  % Now #points=1,3,4,6,7,9,13

switch ch1  % choice 1 for line segments 
case 1 
  % 1-point Gaussian quadrature on a line segment (the center)
  GAUSSQUAD.LINE = [
  0.50000000000000  0.50000000000000  1.00000000000000];
case 2
  % 2-point Gaussian quadrature on a line segment
  GAUSSQUAD.LINE = [
  0.788675134594813   0.211324865405187   0.500000000000000;
  0.211324865405187   0.788675134594813   0.500000000000000];
case 3
  % 3-point Gaussian quadrature on a line segment 
  GAUSSQUAD.LINE = [
  0.88729833462074  0.11270166537926  0.27777777777778; 
  0.50000000000000  0.50000000000000  0.44444444444444; 
  0.11270166537926  0.88729833462074  0.27777777777778];
case 4
  % 4-point Gaussian quadratrue on a line segment
  GAUSSQUAD.LINE = [
  0.930568155797026   0.069431844202974   0.173927422568727;
  0.669990521792428   0.330009478207572   0.326072577431273;
  0.330009478207572   0.669990521792428   0.326072577431273;
  0.069431844202974   0.930568155797026   0.173927422568727];
case 5 
  % 5-point Gaussian quadrature on a line segment 
  GAUSSQUAD.LINE = [
  0.95308992295000  0.04691007705000  0.11846344250000;
  0.76923465505000  0.23076534495000  0.23931433525000; 
  0.50000000000000  0.50000000000000  0.28444444445000; 
  0.23076534495000  0.76923465505000  0.23931433525000; 
  0.04691007705000  0.95308992295000  0.11846344250000];
case 6 
  % 6-point Gaussian quadrature on a line segment
  GAUSSQUAD.LINE = [
  0.966234757101576   0.033765242898424   0.085662246189585;
  0.830604693233132   0.169395306766868   0.180380786524069;
  0.619309593041598   0.380690406958402   0.233956967286345;
  0.380690406958402   0.619309593041598   0.233956967286345;
  0.169395306766868   0.830604693233132   0.180380786524069;
  0.033765242898424   0.966234757101576   0.085662246189585];
case 7 
  % 7-point Gaussian quadrature on a line segment
  GAUSSQUAD.LINE = [
  0.974553956171379   0.025446043828621   0.064742483084435;
  0.870765592799697   0.129234407200303   0.139852695744638;
  0.702922575688699   0.297077424311301   0.190915025252559;
  0.500000000000000   0.500000000000000   0.208979591836735;
  0.297077424311301   0.702922575688699   0.190915025252559;
  0.129234407200303   0.870765592799697   0.139852695744638;
  0.025446043828621   0.974553956171379   0.064742483084435];
case 8 
  % 8-point Gaussian quadrature on a line segment
  GAUSSQUAD.LINE = [
  0.980144928248768   0.019855071751232   0.050614268145188;
  0.898333238706813   0.101666761293187   0.111190517226687;
  0.762766204958164   0.237233795041836   0.156853322938944;
  0.591717321247825   0.408282678752175   0.181341891689181;
  0.408282678752175   0.591717321247825   0.181341891689181;
  0.237233795041836   0.762766204958164   0.156853322938944;
  0.101666761293187   0.898333238706813   0.111190517226687;
  0.019855071751232   0.980144928248768   0.050614268145188];     
case 9
  % 9-point Gaussian quadrature on a line segment 
  GAUSSQUAD.LINE = [
  0.98408011975400  0.01591988024600  0.04063719418080; 
  0.91801555366350  0.08198444633650  0.09032408034750; 
  0.80668571635050  0.19331428364950  0.13030534820150; 
  0.66212671170200  0.33787328829800  0.15617353852000; 
  0.50000000000000  0.50000000000000  0.16511967750050; 
  0.33787328829800  0.66212671170200  0.15617353852000; 
  0.19331428364950  0.80668571635050  0.13030534820150; 
  0.08198444633650  0.91801555366350  0.09032408034750; 
  0.01591988024600  0.98408011975400  0.04063719418080];
case 10
  % 10-point Gaussian quadrature on a line segment 
  GAUSSQUAD.LINE = [
  0.986953264258586   0.013046735741414   0.033335672154344;
  0.932531683344492   0.067468316655508   0.074725674575290;
  0.839704784149512   0.160295215850488   0.109543181257991;
  0.716697697064624   0.283302302935376   0.134633359654998;
  0.574437169490816   0.425562830509184   0.147762112357376;
  0.425562830509184   0.574437169490816   0.147762112357376;
  0.283302302935376   0.716697697064624   0.134633359654998;
  0.160295215850488   0.839704784149512   0.109543181257991;
  0.067468316655508   0.932531683344492   0.074725674575290;
  0.013046735741414   0.986953264258586   0.033335672154344];    
case 15
  % 15-point Gaussian quadrature on a line segment
  GAUSSQUAD.LINE = [
  0.006003740989757  0.993996259010243  0.030753241996117;
  0.031363303799647  0.968636696200353  0.070366047488108;
  0.075896708294786  0.924103291705214  0.107159220467172;
  0.137791134319915  0.862208865680085  0.139570677926154;
  0.214513913695731  0.785486086304269  0.166269205816994;
  0.302924326461218  0.697075673538782  0.186161000015562;
  0.399402953001283  0.600597046998717  0.198431485327112;
  0.500000000000000  0.500000000000000  0.202578241925561;
  0.600597046998717  0.399402953001283  0.198431485327112;
  0.697075673538782  0.302924326461218  0.186161000015562;
  0.785486086304269  0.214513913695731  0.166269205816994;
  0.862208865680085  0.137791134319915  0.139570677926154;
  0.924103291705214  0.075896708294786  0.107159220467172;
  0.968636696200353  0.031363303799647  0.070366047488108;
  0.993996259010243  0.006003740989757  0.030753241996117];
otherwise
  GAUSSQUAD.LINE = [];
  disp('Wrong choice!');
end

% Choice 2 for a rectangle ((x1,y1),(x2,y2)) 
% Usage: 
%   ptx = alpha1x*x1 + (1-alpha1x)*x2
%   pty = alpha1y*y1 + (1-alpha1y)*y2 
switch ch2 
case 1
  % 1-point Gaussian quadrature on a rectangle 
  GAUSSQUAD.RECT = [
  0.50000000000000, 0.50000000000000, 1.00000000000000];
case 4
  % 4-point Gaussian quadrature on a rectangle 
  GAUSSQUAD.RECT = [
  0.788675134594813, 0.788675134594813, 0.250000000000000;
  0.211324865405187, 0.788675134594813, 0.250000000000000;
  0.788675134594813, 0.211324865405187, 0.250000000000000;
  0.211324865405187, 0.211324865405187, 0.250000000000000];
case 9 
  % 9-point Gaussian quadrature on a rectangle 
  GAUSSQUAD.RECT = [
   0.887298334620740,   0.887298334620740, 0.077160493827162;
   0.500000000000000,   0.887298334620740, 0.123456790123457;
   0.112701665379260,   0.887298334620740, 0.077160493827162;
   0.887298334620740,   0.500000000000000, 0.123456790123457;
   0.500000000000000,   0.500000000000000, 0.197530864197527;
   0.112701665379260,   0.500000000000000, 0.123456790123457;
   0.887298334620740,   0.112701665379260, 0.077160493827162;
   0.500000000000000,   0.112701665379260, 0.123456790123457;
   0.112701665379260,   0.112701665379260, 0.077160493827162]; 
case 16
  % 16-point Gaussian quadrature on a rectangle 
  GAUSSQUAD.RECT = [
   0.930568155797026, 0.930568155797026, 0.030250748321401;
   0.669990521792428, 0.930568155797026, 0.056712962962963;
   0.330009478207572, 0.930568155797026, 0.056712962962963;
   0.069431844202974, 0.930568155797026, 0.030250748321401;
   0.930568155797026, 0.669990521792428, 0.056712962962963;
   0.669990521792428, 0.669990521792428, 0.106323325752674;
   0.330009478207572, 0.669990521792428, 0.106323325752674;
   0.069431844202974, 0.669990521792428, 0.056712962962963;
   0.930568155797026, 0.330009478207572, 0.056712962962963;
   0.669990521792428, 0.330009478207572, 0.106323325752674;
   0.330009478207572, 0.330009478207572, 0.106323325752674;
   0.069431844202974, 0.330009478207572, 0.056712962962963;
   0.930568155797026, 0.069431844202974, 0.030250748321401;
   0.669990521792428, 0.069431844202974, 0.056712962962963;
   0.330009478207572, 0.069431844202974, 0.056712962962963;
   0.069431844202974, 0.069431844202974, 0.030250748321401];
case 25
  % 25-point Gaussian quadrature on a rectangle 
  GAUSSQUAD.RECT = [
   0.953089922950000, 0.953089922950000, 0.014033587208951;
   0.769234655050000, 0.953089922950000, 0.028349999993314;
   0.500000000000000, 0.953089922950000, 0.033696268089547;
   0.230765344950000, 0.953089922950000, 0.028349999993314;
   0.046910077050000, 0.953089922950000, 0.014033587208951;
   0.953089922950000, 0.769234655050000, 0.028349999993314;
   0.769234655050000, 0.769234655050000, 0.057271351056149;
   0.500000000000000, 0.769234655050000, 0.068071633139107;
   0.230765344950000, 0.769234655050000, 0.057271351056149;
   0.046910077050000, 0.769234655050000, 0.028349999993314;
   0.953089922950000, 0.500000000000000, 0.033696268089547;
   0.769234655050000, 0.500000000000000, 0.068071633139107;
   0.500000000000000, 0.500000000000000, 0.080908641978469;
   0.230765344950000, 0.500000000000000, 0.068071633139107;
   0.046910077050000, 0.500000000000000, 0.033696268089547;
   0.953089922950000, 0.230765344950000, 0.028349999993314;
   0.769234655050000, 0.230765344950000, 0.057271351056149;
   0.500000000000000, 0.230765344950000, 0.068071633139107;
   0.230765344950000, 0.230765344950000, 0.057271351056149;
   0.046910077050000, 0.230765344950000, 0.028349999993314;
   0.953089922950000, 0.046910077050000, 0.014033587208951;
   0.769234655050000, 0.046910077050000, 0.028349999993314;
   0.500000000000000, 0.046910077050000, 0.033696268089547;
   0.230765344950000, 0.046910077050000, 0.028349999993314;
   0.046910077050000, 0.046910077050000, 0.014033587208951];
otherwise
  GAUSSQUAD.RECT = [];
  disp('Wrong choice!');
end

switch ch3  % choice 3 for triangles 
case 1 
  % 1-point (the center) quad. for triangles, Exact for poly. deg.<=1 
  GAUSSQUAD.TRIG = zeros(1,4);
  GAUSSQUAD.TRIG(:,1:3) = [1/3, 1/3, 1/3];
  GAUSSQUAD.TRIG(:,4) = 1;
case 3 
  % 3-point quadrature for triangles, Exact for poly. deg.<=2 
  GAUSSQUAD.TRIG = zeros(3,4);
  GAUSSQUAD.TRIG(:,1:3) = [4,1,1; 1,4,1; 1,1,4]/6;
  GAUSSQUAD.TRIG(:,4) = [1; 1; 1]/3;
case 4 
  % 4-point quadrature for triangles, Exact for poly. deg.<=3 
  a = 1/3;  b = 9/15;  c = 3/15;
  u = -27/48;  v = 25/48;
  GAUSSQUAD.TRIG = zeros(4,4);
  GAUSSQUAD.TRIG(:,1:3) = [a,a,a; b,c,c; c,b,c; c,c,b];
  GAUSSQUAD.TRIG(:,4) = [u; v;v;v];
case 6 
  % 6-point quadrature for triangles, Exact for poly. deg.<=4 
  a = 0.816847572980459;  b = 0.091576213509771;
  c = 0.108103018168070;  d = 0.445948490915965;
  u = 0.109951743655322;  v = 0.223381589678011;
  GAUSSQUAD.TRIG = zeros(6,4);
  GAUSSQUAD.TRIG(:,1:3) = [a,b,b; b,a,b; b,b,a; c,d,d; d,c,d; d,d,c];
  GAUSSQUAD.TRIG(:,4) = [u;u;u; v;v;v];
case 7
  % 7-point quadrature for triangles, Exact for poly. deg.<=5 
  a = 1/3;  
  b = (9+2*sqrt(15))/21;  % b = 0.797426985353087; 
  c =   (6-sqrt(15))/21;  % c = 0.101286507323456; 
  d =   (6+sqrt(15))/21;  % d = 0.470142064105115; 
  e = (9-2*sqrt(15))/21;  % e = 0.059715871789770;
  u = 0.225;  v = (155-sqrt(15))/1200.0;  w = (155+sqrt(15))/1200;
  GAUSSQUAD.TRIG = zeros(7,4);
  GAUSSQUAD.TRIG(:,1:3) = [a,a,a; b,c,c; c,b,c; c,c,b;...
    d,d,e; d,e,d; e,d,d];
  GAUSSQUAD.TRIG(:,4) = [u; v;v;v; w;w;w];
case 9 
  % 9-point quadrature for triangles, Exact for poly. deg.<=6 
  a = 0.437525248383384;  b = 0.124949503233232;
  c = 0.797112651860071;  d = 0.165409927389841;  e = 0.037477420750088;
  u = 0.205950504760887;  v = 0.063691414286223;
  GAUSSQUAD.TRIG(:,1:3) = [a,a,b; a,b,a; b,a,a;...
    c,d,e; c,e,d; d,c,e; d,e,c; e,c,d; e,d,c];
  GAUSSQUAD.TRIG(:,4) = [u;u;u; v;v;v;v;v;v];
case 12 
  % JL20130930: See Riv_BookSIAM_2008, pp.160--161 
  % 12-point quadrature for triangles, Exact for poly. deg.<=6 
  GAUSSQUAD.TRIG = zeros(12,4);
case 13 
  % 13-point quadrature for triangles, Exact for poly. deg.<=7 
  a = 0.479308067841923;  b = 0.260345966079039;
  c = 0.869739794195568;  d = 0.065130102902216;
  e = 0.638444188569809;  f = 0.312865496004875;  g = 0.048690315425316;
  s =-0.149570044467670;  t = 0.175615257433204;
  u = 0.053347235608839;  v = 0.077113760890257;
  GAUSSQUAD.TRIG = zeros(13,4);
  GAUSSQUAD.TRIG(:,1:3) = [1/3,1/3,1/3;...
    a,b,b; b,a,b; b,b,a; c,d,d; d,c,d; d,d,c;...
    e,f,g; e,g,f; f,e,g; f,g,e; g,e,f; g,f,e];
  GAUSSQUAD.TRIG(:,4) = [s; t;t;t; u;u;u; v;v;v;v;v;v];
otherwise  % default 1-point 
  % disp('Wrong choice, default: 1-point');
  GAUSSQUAD.TRIG = zeros(1,4);
  GAUSSQUAD.TRIG(:,1:3) = [1/3, 1/3, 1/3];
  GAUSSQUAD.TRIG(:,4) = 1;
end

return;