function NCP1BasFxnGrad = NC_TriP1_BasFxnGrad(TriMesh)
%% Nonconforming FEs: Triangular mesh: Nonconforming P1 bas.fxns.: Gradients 
% For all elements, 3 edge-midpoint basis functions: (constant-vector) gradients 
% James Liu, ColoState; 2012/07--2017/02 

%% Mesh info 
NumEms = TriMesh.NumEms;
k1 = TriMesh.elem(:,1);  k2 = TriMesh.elem(:,2);  k3 = TriMesh.elem(:,3);
x1 = TriMesh.node(k1,1);  y1 = TriMesh.node(k1,2); 
x2 = TriMesh.node(k2,1);  y2 = TriMesh.node(k2,2);
x3 = TriMesh.node(k3,1);  y3 = TriMesh.node(k3,2);
xm1 = 0.5*(x2+x3);  ym1 = 0.5*(y2+y3);
xm2 = 0.5*(x3+x1);  ym2 = 0.5*(y3+y1);
xm3 = 0.5*(x1+x2);  ym3 = 0.5*(y1+y2);
marea = 0.5*((xm2-xm1).*(ym3-ym1)-(xm3-xm1).*(ym2-ym1));

%% 
NCP1BasFxnGrad = zeros(NumEms,3,2);
NCP1BasFxnGrad(:,1,:) = [(ym2-ym3)./(2*marea), (xm3-xm2)./(2*marea)];
NCP1BasFxnGrad(:,2,:) = [(ym3-ym1)./(2*marea), (xm1-xm3)./(2*marea)];
NCP1BasFxnGrad(:,3,:) = [(ym1-ym2)./(2*marea), (xm2-xm1)./(2*marea)];

return;