function CofRT0 = Hdiv_TriRT0_NmlzBas_ProjVecFxn(VecFxn,TriMesh,GAUSSQUAD)
%% "Hdiv" local RT0 on tri.mesh: Projection of a vector fxn. in normalized bas.
% James Liu, ColoState; 2012/07--2017/02 

%% Mesh info 
NumEms = TriMesh.NumEms;
k1 = TriMesh.elem(:,1);  k2 = TriMesh.elem(:,2);  k3 = TriMesh.elem(:,3);
x1 = TriMesh.node(k1,1);  y1 = TriMesh.node(k1,2); 
x2 = TriMesh.node(k2,1);  y2 = TriMesh.node(k2,2);
x3 = TriMesh.node(k3,1);  y3 = TriMesh.node(k3,2);
area = 0.5*abs((x2-x1).*(y3-y1)-(x3-x1).*(y2-y1));
xc = (1/3)*(x1+x2+x3);
yc = (1/3)*(y1+y2+y3);

%% Computing the inner products / integrals 
RHS = zeros(NumEms,3);
NumQuadPts = size(GAUSSQUAD.TRIG,1);
for k=1:NumQuadPts
  qp = GAUSSQUAD.TRIG(k,1) * TriMesh.node(TriMesh.elem(:,1),:)...
     + GAUSSQUAD.TRIG(k,2) * TriMesh.node(TriMesh.elem(:,2),:)...
     + GAUSSQUAD.TRIG(k,3) * TriMesh.node(TriMesh.elem(:,3),:);
  vec = VecFxn(qp);
  X = qp(:,1) - xc;  Y = qp(:,2) - yc;
  RHS(:,1) = RHS(:,1) + GAUSSQUAD.TRIG(k,4) * vec(:,1);
  RHS(:,2) = RHS(:,2) + GAUSSQUAD.TRIG(k,4) * vec(:,2);
  RHS(:,2) = RHS(:,2) + GAUSSQUAD.TRIG(k,4) * (vec(:,1).*X+vec(:,2).*Y);
end
RHS = RHS.*area;

%% Computing the Gram matrix for RT0 nml.bas.
% GMRT0 has size NumEms*3 
GMRT0 = Hdiv_TriRT0_NmlzBas_GramMat(TriMesh);

%% Comuting the projection coefficients in RT0 
CofRT0 = RHS./GMRT0;

return;