function GM = Hdiv_TriRT0_NmlzBas_GramMat(TriMesh)
%% "Hdiv" local RT0 on a triangular mesh: Gram matrices for normalized basis
% [1;0], [0;1]; [X;Y] where X=x-xc, Y=y-yc and (xc,yc) is element center
% James Liu, ColoState; 2012/07--2017/02 

%% Mesh info 
% NumEms = TriMesh.NumEms;
k1 = TriMesh.elem(:,1);  k2 = TriMesh.elem(:,2);  k3 = TriMesh.elem(:,3);
x1 = TriMesh.node(k1,1);  y1 = TriMesh.node(k1,2); 
x2 = TriMesh.node(k2,1);  y2 = TriMesh.node(k2,2);
x3 = TriMesh.node(k3,1);  y3 = TriMesh.node(k3,2);
area = 0.5*abs((x2-x1).*(y3-y1)-(x3-x1).*(y2-y1));

%% Auxiliary integrals 
SX2 = (area/36).*( (x1-x2).^2 + (x2-x3).^2 + (x3-x1).^2 );
SY2 = (area/36).*( (y1-y2).^2 + (y2-y3).^2 + (y3-y1).^2 );

%% Gram matrices for all elements in the triangular mesh 
% For each element, Gram matrix is 3x3 diagonal mat., but stored as 3-vec.
GM = [area, area, SX2+SY2];

return;