function GMK1 = Hdiv_TriRT0_EgBas_GramMatK1(TriMesh,MatK)
%% Hdiv: RT0: Gram matrices in edge-based basis fxns. for a tri.mesh 
% Used mainly for MFEM (MatK1 represents the inverse matrix of MatK)
% James Liu, ColoState; 2012/07--2021/01 

%% Mesh info 
NumEms = TriMesh.NumEms;
% Assuming TriMesh.flag>=3 
e2g = TriMesh.elem2edge;
area = TriMesh.area;
LenEg = TriMesh.LenEg;

%% Gram matrices: Locally for individual elements 
% Assuming vrtx is a 2-by-3 matrix 
GMK1 = zeros(NumEms,3,3);
GM = [2,1,1; 1,2,1; 1,1,2];
for ie=1:NumEms
  MatK1 = inv(squeeze(MatK(ie,:,:)));
  A = kron(GM, MatK1);
  vrtx = (TriMesh.node(TriMesh.elem(ie,1:3),:))';
  B = [vrtx(:),vrtx(:),vrtx(:)] - [vrtx;vrtx;vrtx];
  C = diag(LenEg(e2g(ie,1:3)));
  GMK1(ie,1:3,1:3) = (1/48)/area(ie) * (C'*B'*A*B*C);
end

return;