function ProjCof = Hdiv_RectRT0_NmlzBas_ProjMatK(RectMesh, MatK)
%% "Hdiv" local RT[0] on rect.mesh: Normalized basis: Projection with MatK  
% Projection coefficients of (MatK * nmlz.bas.fxn.) back in nmlz.bas. 
% MatK is an elementwise constant 2x2 matrix 
% ProjCof has the size #Elements*4*4 (in the order [1;0],[0;1],[X;0],[0;Y])
% James Liu, ColoState; 2012/07--2017/02 

%% Mesh info 
NumEms = RectMesh.NumEms;

%% Projection coefficients 
ProjCof = zeros(NumEms,4,4);
ZO = zeros(NumEms,1);
ProjCof(:,1,:) = [MatK(:,1,1), MatK(:,2,1), ZO, ZO];
ProjCof(:,2,:) = [MatK(:,1,2), MatK(:,2,2), ZO, ZO];
ProjCof(:,3,:) = [ZO, ZO, MatK(:,1,1), ZO];
ProjCof(:,4,:) = [ZO, ZO, ZO, MatK(:,2,2)];

return;