function NmlFlux = Hdiv_RectRT0_NmlzBas_NmlFlux(RectMesh)
%% Hdiv local RT[0] on rect.mesh: 4 nmlz.bas.fxns., 4 edge outward normal fluxes
% This is not an Hdiv-subspace (Hdiv named abused, actually broken "Hdiv") 
%   Normalized basis: [1;0], [0;1], [X;0], [0;Y]
%   where X=x-xc, Y=y-yc and (xc,yc) is element center
% James Liu, ColoState; 2012/07--2017/02 

%% Mesh info and auxiliary quantities 
NumEms = RectMesh.NumEms;
k1 = RectMesh.elem(:,1);  k2 = RectMesh.elem(:,3);
x1 = RectMesh.node(k1,1);  y1 = RectMesh.node(k1,2); 
x2 = RectMesh.node(k2,1);  y2 = RectMesh.node(k2,2);
Deltax = x2 - x1;  
Deltay = y2 - y1;
area = Deltax .* Deltay;

%% Elementwise 4 edge outward normal fluxes of 4 nmlz.bas.fxns. 
% Four edges: 1-bottom, 2-right, 3-top, 4-left  
NmlFlux = zeros(NumEms,4,4);  % All elements, 4 basis functions, 4 edges 

% For the basis function [1;0] 
NmlFlux(:,1,2) =  Deltay;  
NmlFlux(:,1,4) = -Deltay;

% For the basis function [0;1] 
NmlFlux(:,2,1) = -Deltax;  
NmlFlux(:,2,3) =  Deltax;

% For the basis function [X;0] 
NmlFlux(:,3,2) = 0.5*area;
NmlFlux(:,3,4) = 0.5*area;

% For the basis function [0;Y] 
NmlFlux(:,4,1) = 0.5*area;
NmlFlux(:,4,3) = 0.5*area;

return;