function GM = Hdiv_RectRT0_NmlzBas_GramMat(RectMesh)
%% Hdiv local RT[0] on a rectangular mesh: Gram matrix for normalized basis 
% This is not an Hdiv-subspace (Hdiv named abused, actually broken "Hdiv") 
%   Normalized basis: [1;0], [0;1], [X;0], [0;Y]
%   where X=x-xc, Y=y-yc and (xc,yc) is element center
% James Liu, ColoState; 2012/07--2017/02 

%% Mesh info and auxiliary quantties 
% NumEms = RectMesh.NumEms;
k1 = RectMesh.elem(:,1);  k2 = RectMesh.elem(:,3);
x1 = RectMesh.node(k1,1);  y1 = RectMesh.node(k1,2); 
x2 = RectMesh.node(k2,1);  y2 = RectMesh.node(k2,2);
Deltax = x2 - x1;  
Deltay = y2 - y1;
area = Deltax.*Deltay;

%% Gram matrices for all elements in the rectangular mesh 
% For each element, Gram matrix is 4x4 diagonal mat., but stored as 4-vec.
% GM = zeros(NumEms,4);
GM = [area, area, area/12.*(Deltax.^2), area/12.*(Deltay.^2)];

return;