function GM = Hdiv_QuadriAC02_NmlzPiolaBas_GramMat(QuadriMesh,GAUSSQUAD)
%% "Hdiv" local AC0^2 on quadrilateral mesh: 
% Gram matrix for (normalized + Piola) basis 
% James Liu, ColoState; 2017/02--2017/09 

%% Mesh info 
NumEms = QuadriMesh.NumEms; 

%% Gram matrix for AC0 
GMAC0 = Hdiv_QuadriAC0_NmlzPiolaBas_GramMat(QuadriMesh,GAUSSQUAD);

%% Gram matrix for AC0^2 
GM = zeros(NumEms,8,8);
GM(:, 1:4, 1:4) = GMAC0;
GM(:, 5:8, 5:8) = GMAC0;

return;