function [GMQ,GMT] = Hdiv_HybridRT0_NmlzBas_GramMat(HybridMesh)
%% Gram matrix for RT0 in normalized basis for hybrid mesh of quaris. & trigs.
% This is not an Hdiv-subspace (Hdiv named abused, actually broken "Hdiv")  
%   for quadrilaterals: [1;0], [0;1], [X;Y]
%   for triangles:      [1;0], [0;1], [X;0], [0;Y]
%   where X=x-xc, Y=y-yc and (xc,yc) is element center
% Using implicitly a Gaussian quadrature for quadrilaterals
% James Liu, Zhuoran Wang, ColoState; 2012/07--2017/02 

%% Mesh info 
NumEmsQ = HybridMesh.NumEmsQ;
% NumEmsT = HybridMesh.NumEmsT;

%% Auxiliary quantities for quadrilateral elements
%
k1 = HybridMesh.elemQ(:,1);  k2 = HybridMesh.elemQ(:,2);  
k3 = HybridMesh.elemQ(:,3);  k4 = HybridMesh.elemQ(:,4);
%
x1 = HybridMesh.node(k1,1);  y1 = HybridMesh.node(k1,2);
x2 = HybridMesh.node(k2,1);  y2 = HybridMesh.node(k2,2);
x3 = HybridMesh.node(k3,1);  y3 = HybridMesh.node(k3,2);
x4 = HybridMesh.node(k4,1);  y4 = HybridMesh.node(k4,2);
%
area = 0.5*( (x2-x1).*(y3-y1) - (x3-x1).*(y2-y1)...
           + (x3-x1).*(y4-y1) - (x4-x1).*(y3-y1));
%
xc = 0.25 * (x1+x2+x3+x4);
yc = 0.25 * (y1+y2+y3+y4);
% 
% Coefficients for the bilinear mapping for quadrilaterals
CofA = zeros(NumEmsQ,4);      CofB = zeros(NumEmsQ,4);
CofA(:,1) = x1;               CofB(:,1) = y1;
CofA(:,2) = x2-x1;            CofB(:,2) = y2-y1;
CofA(:,3) = x4-x1;            CofB(:,3) = y4-y1;
CofA(:,4) = (x1+x3)-(x2+x4);  CofB(:,4) = (y1+y3)-(y2+y4);
%
% Computing quadri. auxiliary quantities using Gaussian quadrature on [0,1]^2
SX = zeros(NumEmsQ,1);  SX2 = zeros(NumEmsQ,1);
SY = zeros(NumEmsQ,1);  SY2 = zeros(NumEmsQ,1);
GAUSSQUADRECT = SetGaussQuadRect(5,5);
NumQuadPts = size(GAUSSQUADRECT,1);
GAUSSQUADRECT1 = ones(NumQuadPts,2) - GAUSSQUADRECT(:,1:2);
qp = zeros(NumEms,2);
for k=1:NumQuadPts
  xhat = GAUSSQUADRECT1(k,1);
  yhat = GAUSSQUADRECT1(k,2);
  qp(:,1) = CofA(:,1) + CofA(:,2)*xhat + CofA(:,3)*yhat + CofA(:,4)*xhat*yhat;
  qp(:,2) = CofB(:,1) + CofB(:,2)*xhat + CofB(:,3)*yhat + CofB(:,4)*xhat*yhat;
  jac = (CofB(:,3)+CofB(:,4)*xhat) .* (CofA(:,2)+CofA(:,4)*yhat)...
      - (CofA(:,3)+CofA(:,4)*xhat) .* (CofB(:,2)+CofB(:,4)*yhat);
  X = qp(:,1) - xc;
  Y = qp(:,2) - yc;
  SX = SX + GAUSSQUADRECT(k,3)*jac.*X;
  SY = SY + GAUSSQUADRECT(k,3)*jac.*Y;
  SX2 = SX2 + GAUSSQUADRECT(k,3)*jac.*(X.*X);
  SY2 = SY2 + GAUSSQUADRECT(k,3)*jac.*(Y.*Y);
end

%% GMQ: Gram matrices for all quadrilateral elements in the hybrid mesh 
% For each quadri. element, Gram matrix is a 4x4 matrix
GMQ = zeros(NumEmsQ,4,4);
GMQ(:,1,1) = area;  GMQ(:,2,2) = area;
GMQ(:,1,3) = SX;    GMQ(:,2,4) = SY;
GMQ(:,3,1) = SX;    GMQ(:,4,2) = SY;
GMQ(:,3,3) = SX2;   GMQ(:,4,4) = SY2;

%% Auxiliary quantities for triangular elements 
k1 = HybridMesh.elemT(:,1);  
k2 = HybridMesh.elemT(:,2);  
k3 = HybridMesh.elemT(:,3);
x1 = HybridMesh.node(k1,1);  y1 = HybridMesh.node(k1,2); 
x2 = HybridMesh.node(k2,1);  y2 = HybridMesh.node(k2,2);
x3 = HybridMesh.node(k3,1);  y3 = HybridMesh.node(k3,2);
area = 0.5*abs((x2-x1).*(y3-y1)-(x3-x1).*(y2-y1));
SX2 = (area/36).*( (x1-x2).^2 + (x2-x3).^2 + (x3-x1).^2 );
SY2 = (area/36).*( (y1-y2).^2 + (y2-y3).^2 + (y3-y1).^2 );

%% GMT: Gram matrices for all triangular elements in the hybrid mesh 
% For each trig. element, Gram matrix is 3x3 diagonal mat., but stored as 3-vec.
% GMT = zeros(NumEmsT,3);
GMT = [area, area, SX2+SY2];

return;